/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.dsl.application;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametiste.laplatform.protocol.ProtocolGateway;
import org.ametiste.laplatform.sdk.protocol.Protocol;
import org.ametiste.routine.dsl.annotations.Connect;
import org.ametiste.routine.dsl.application.DynamicOperation;
import org.ametiste.routine.dsl.application.ParameterProvider;
import org.ametiste.routine.meta.util.MetaMethod;
import org.ametiste.routine.meta.util.MetaMethodParameter;
import org.ametiste.routine.meta.util.MetaObject;
import org.ametiste.routine.sdk.operation.OperationFeedback;
import org.springframework.util.ReflectionUtils;

public class DynamicOperationFactory {
    private final Method method;
    private final Class<?> controllerClass;
    private final List<ParameterProvider> parameterProviders;

    public DynamicOperationFactory(Class<?> controllerClass, Method method, List<ParameterProvider> parameterProviders) {
        this.controllerClass = controllerClass;
        this.method = method;
        this.parameterProviders = parameterProviders;
    }

    public DynamicOperation createDynamicOperation(OperationFeedback operationFeedback, ProtocolGateway protocolGateway) {
        Object controllerInstance = this.createOperationControllerInstance();
        MetaMethod metaMethod = MetaMethod.of(MetaObject.of(controllerInstance), this.method);
        Stream.of(this.controllerClass.getDeclaredFields()).filter(f -> f.isAnnotationPresent(Connect.class)).forEach(f -> {
            Protocol session = protocolGateway.session(f.getType());
            ReflectionUtils.makeAccessible((Field)f);
            ReflectionUtils.setField((Field)f, (Object)controllerInstance, (Object)session);
        });
        Object[] params = metaMethod.streamOfParameters().map(p -> this.resolveMethodParameters((MetaMethodParameter)p, protocolGateway)).collect(Collectors.toList()).toArray(new Object[metaMethod.paramsCount()]);
        return () -> {
            try {
                this.method.invoke(controllerInstance, params);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private Object resolveMethodParameters(MetaMethodParameter methodParameter, ProtocolGateway protocolGateway) {
        return this.parameterProviders.stream().map(p -> p.provideValue(methodParameter, protocolGateway)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new IllegalStateException("There is no resolved parameters."));
    }

    private Object createOperationControllerInstance() {
        Object controllerInstance;
        try {
            controllerInstance = this.controllerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        return controllerInstance;
    }
}

