/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.meta.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.ametiste.routine.meta.util.MetaMethod;

public class MetaObject {
    final Object object;
    private final Class<?> klass;

    public MetaObject(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Given object is null.");
        }
        this.object = object;
        this.klass = object.getClass();
    }

    public long countAnnotatedMethod(Class<? extends Annotation> annotationClass) {
        return Stream.of(this.klass.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(annotationClass)).count();
    }

    public void assertTypeAnnotation(Class<? extends Annotation> annotationClass) {
        if (!this.klass.isAnnotationPresent(annotationClass)) {
            throw new IllegalStateException("@" + annotationClass.getSimpleName() + " is required to be declared for " + this.klass.getName());
        }
    }

    public Optional<MetaMethod> oneAnnotatedMethod(Class<? extends Annotation> annotationClass) {
        if (this.countAnnotatedMethod(annotationClass) != 1L) {
            return Optional.empty();
        }
        return Stream.of(this.klass.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(annotationClass)).map(m -> MetaMethod.of(this, m)).findFirst();
    }

    public <T, S extends Annotation> Optional<T> annotationValue(Class<S> annotationClass, Function<S, T> valueProducer) {
        if (!this.klass.isAnnotationPresent(annotationClass)) {
            return Optional.empty();
        }
        return Optional.ofNullable(valueProducer.apply(this.klass.getDeclaredAnnotation(annotationClass)));
    }

    public Stream<Field> streamOfAnnotatedFields(Class<? extends Annotation> annotationClass) {
        return Stream.of(this.klass.getDeclaredFields()).filter(f -> f.isAnnotationPresent(annotationClass));
    }

    public Stream<MetaMethod> streamOfMethodsWithoutAnnotation(Class<? extends Annotation> annotationClass) {
        return Stream.of(this.klass.getMethods()).filter(f -> !f.isAnnotationPresent(annotationClass)).map(m -> MetaMethod.of(this, m));
    }

    public Stream<MetaMethod> streamOfAnnotatedMethods(Class<? extends Annotation> annotationClass) {
        return Stream.of(this.klass.getMethods()).filter(f -> f.isAnnotationPresent(annotationClass)).map(m -> MetaMethod.of(this, m));
    }

    public Object object() {
        return this.object;
    }

    public static final MetaObject of(Object object) {
        return new MetaObject(object);
    }

    public static final MetaObject from(Class<?> klass) {
        try {
            return MetaObject.of(klass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }
}

