/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.persistency.memory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametiste.routine.domain.scheme.OperationScheme;
import org.ametiste.routine.domain.scheme.SchemeRepository;
import org.ametiste.routine.domain.scheme.TaskScheme;
import org.ametiste.routine.sdk.protocol.operation.ParamsProtocol;

public class InMemorySchemeRepository
implements SchemeRepository {
    private final Map<String, TaskScheme> taskSchemasByName = new HashMap<String, TaskScheme>();
    private final Map<Class<? extends TaskScheme>, TaskScheme> taskSchemasByClass = new HashMap<Class<? extends TaskScheme>, TaskScheme>();
    private final Map<String, Class<? extends TaskScheme>> taskSchemasClassesByName = new HashMap<String, Class<? extends TaskScheme>>();
    private final Map<String, OperationScheme> opSchemasByName = new HashMap<String, OperationScheme>();
    private final Map<Class<? extends OperationScheme>, OperationScheme> opSchemasByClass = new HashMap<Class<? extends OperationScheme>, OperationScheme>();
    private final Map<String, Class<? extends OperationScheme>> opSchemasClassesByName = new HashMap<String, Class<? extends OperationScheme>>();

    public InMemorySchemeRepository(Map<String, TaskScheme> taskSchemas, Map<String, OperationScheme> opSchemas) {
        taskSchemas.values().forEach(this::saveScheme);
        opSchemas.values().forEach(this::saveScheme);
    }

    public TaskScheme findTaskScheme(String taskSchemeName) {
        return this.notNull(this.taskSchemasByName.get(taskSchemeName), taskSchemeName);
    }

    public <T extends ParamsProtocol> OperationScheme<T> findOperationScheme(Class<? extends OperationScheme<T>> operationSchemeClass) {
        return this.notNull(this.opSchemasByClass.get(operationSchemeClass), operationSchemeClass.getSimpleName());
    }

    public <T extends ParamsProtocol> TaskScheme<T> findTaskScheme(Class<? extends TaskScheme<T>> taskSchemeClass) {
        return this.notNull(this.taskSchemasByClass.get(taskSchemeClass), taskSchemeClass.getSimpleName());
    }

    public <T extends ParamsProtocol> Class<TaskScheme<T>> findTaskSchemeClass(String schemeName, Class<T> paramsClass) {
        return this.notNull(this.taskSchemasClassesByName.get(schemeName), schemeName);
    }

    public List<String> loadTaskSchemeNames() {
        return new ArrayList<String>(this.taskSchemasByName.keySet());
    }

    public List<String> loadOperationSchemeNames() {
        return new ArrayList<String>(this.opSchemasByName.keySet());
    }

    public OperationScheme findOperationScheme(String operationName) {
        return this.notNull(this.opSchemasByName.get(operationName), operationName);
    }

    public void saveScheme(OperationScheme<?> operationScheme) {
        this.opSchemasByName.put(operationScheme.schemeName(), operationScheme);
        this.opSchemasByClass.put(operationScheme.getClass(), operationScheme);
        this.opSchemasClassesByName.put(operationScheme.schemeName(), operationScheme.getClass());
    }

    public void saveScheme(TaskScheme<?> taskScheme) {
        this.taskSchemasByName.put(taskScheme.schemeName(), taskScheme);
        this.taskSchemasByClass.put(taskScheme.getClass(), taskScheme);
        this.taskSchemasClassesByName.put(taskScheme.schemeName(), taskScheme.getClass());
    }

    private <T> T notNull(T object, String schemeName) {
        if (object == null) {
            throw new RuntimeException("Can't find registered scheme for: " + schemeName);
        }
        return object;
    }
}

