/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.persistency.jpa;

import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Path;
import org.ametiste.routine.domain.task.Task;
import org.ametiste.routine.domain.task.properties.TaskProperty;
import org.ametiste.routine.infrastructure.persistency.jpa.data.TaskData;
import org.ametiste.routine.infrastructure.persistency.jpa.data.TaskData_;
import org.ametiste.routine.infrastructure.persistency.jpa.data.TaskPropertyData_;
import org.springframework.data.jpa.domain.Specification;

public class TaskDataSpecifications {
    public static Specification<TaskData> hasScheme(String schemeId) {
        return (root, query, cb) -> cb.equal((Expression)root.get(TaskData_.schemeId), (Object)schemeId);
    }

    public static Specification<TaskData> hasCreator(String creatorId) {
        return (root, query, cb) -> cb.equal((Expression)root.get(TaskData_.creatorId), (Object)creatorId);
    }

    public static Specification<TaskData> hasProperty(TaskProperty taskProperty) {
        return (root, query, cb) -> {
            ListJoin join = root.join(TaskData_.properties);
            Path stringPath = root.get(TaskData_.state);
            return cb.and((Expression)cb.equal((Expression)join.get(TaskPropertyData_.name), (Object)taskProperty.name()), (Expression)cb.equal((Expression)join.get(TaskPropertyData_.value), (Object)taskProperty.value()));
        };
    }

    public static Specification<TaskData> hasState(List<Task.State> states) {
        return (root, query, cb) -> root.get(TaskData_.state).in((Collection)states.stream().map(Enum::name).collect(Collectors.toList()));
    }

    public static Specification<TaskData> afterCreationTime(Instant crTime) {
        return (root, criteriaQuery, criteriaBuilder) -> criteriaBuilder.lessThan((Expression)root.get(TaskData_.creationTime), (Comparable)Date.from(crTime));
    }

    public static Specification<TaskData> afterExecStartTime(Instant execTime) {
        return (root, criteriaQuery, criteriaBuilder) -> criteriaBuilder.lessThan((Expression)root.get(TaskData_.executionStartTime), (Comparable)Date.from(execTime));
    }

    public static Specification<TaskData> afterCompletionTime(Instant coTime) {
        return (root, criteriaQuery, criteriaBuilder) -> criteriaBuilder.lessThan((Expression)root.get(TaskData_.completionTime), (Comparable)Date.from(coTime));
    }
}

