/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.messaging;

import java.util.UUID;
import org.ametiste.routine.domain.task.TaskTerminatedEvent;
import org.ametiste.routine.infrastructure.execution.TaskExecutionGateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.annotation.JmsListener;

public class JmsTaskExecutionGatewayListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TaskExecutionGateway taskExecutionGateway;

    public JmsTaskExecutionGatewayListener(TaskExecutionGateway taskExecutionGateway) {
        this.taskExecutionGateway = taskExecutionGateway;
    }

    @JmsListener(destination="task-terminated")
    public void onTaskTerminated(TaskTerminatedEvent event) throws Exception {
        this.taskExecutionGateway.terminateTaskExecution(event.taskId());
    }

    @JmsListener(destination="task-issued")
    public void onTaskPrepared(UUID taskId) throws Exception {
        this.taskExecutionGateway.startTaskExecution(taskId);
    }
}

