/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.laplatform;

import java.time.Duration;
import java.time.LocalDateTime;
import org.ametiste.routine.infrastructure.laplatform.PeriodStats;
import org.ametiste.routine.infrastructure.laplatform.Stats;

public class ProtocolStats {
    private static final ProtocolStats EMPTY = new ProtocolStats("", Stats.empty(), PeriodStats.empty());
    private final String name;
    private final Stats stats;
    private final PeriodStats periodStats;

    public ProtocolStats(String name, Stats stats, PeriodStats periodStats) {
        this.name = name;
        this.stats = stats;
        this.periodStats = periodStats;
    }

    public String name() {
        return this.name;
    }

    public Duration period() {
        return this.periodStats.duration();
    }

    public long createdForPeriod() {
        return this.periodStats.createdForPeriod();
    }

    public long createdCount() {
        return this.stats.createdCount();
    }

    public long currentCount() {
        return this.stats.currentCount();
    }

    public LocalDateTime renewAt() {
        return this.periodStats.renewAt();
    }

    ProtocolStats incCreated() {
        return new ProtocolStats(this.name, this.stats.incCreated(), this.periodStats.incCreated());
    }

    ProtocolStats incCurrent() {
        return new ProtocolStats(this.name, this.stats.incCurrent(), this.periodStats.incCurrent());
    }

    ProtocolStats decCurrent() {
        return new ProtocolStats(this.name, this.stats.decCurrent(), this.periodStats);
    }

    static ProtocolStats periodic(String name, Duration duration) {
        return new ProtocolStats(name, Stats.empty(), PeriodStats.renewedAfter(duration));
    }

    static ProtocolStats empty() {
        return EMPTY;
    }

    public boolean isNotEmpty() {
        return this != ProtocolStats.empty();
    }
}

