/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.laplatform;

import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.ametiste.laplatform.sdk.protocol.Protocol;
import org.ametiste.routine.infrastructure.laplatform.ProtocolStats;

public class LaPlatformStatsService {
    static final Duration aggregateionPeriod = Duration.ofSeconds(30L);
    private final ConcurrentHashMap<Class<? extends Protocol>, ProtocolStats> stats = new ConcurrentHashMap();

    public void loadProtocolStats(Consumer<ProtocolStats> protocolStatsConsumer) {
        this.stats.values().stream().filter(ProtocolStats::isNotEmpty).forEach(protocolStatsConsumer);
    }

    public ProtocolStats loadProtocolStats(Class<? extends Protocol> protocolType) {
        return this.stats.getOrDefault(protocolType, ProtocolStats.empty());
    }

    void incCreated(Class<? extends Protocol> protocolType, String name) {
        this.stats.put(protocolType, this.stats.getOrDefault(protocolType, ProtocolStats.periodic(name, aggregateionPeriod)).incCreated());
    }

    void incCurrent(Class<? extends Protocol> protocolType, String name) {
        this.stats.put(protocolType, this.stats.getOrDefault(protocolType, ProtocolStats.periodic(name, aggregateionPeriod)).incCurrent());
    }

    void decCurrent(Class<? extends Protocol> protocolType) {
        if (this.stats.containsKey(protocolType)) {
            this.stats.put(protocolType, this.stats.get(protocolType).decCurrent());
        }
    }
}

