/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.configuration.protocol;

import org.ametiste.laplatform.sdk.protocol.GatewayContext;
import org.ametiste.laplatform.sdk.protocol.ProtocolFactory;
import org.ametiste.routine.infrastructure.protocol.http.RestTemplateHttpConnection;
import org.ametiste.routine.sdk.protocol.http.HttpProtocol;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnProperty(prefix="org.ametiste.routine", name={"protocol.http.enabled"}, matchIfMissing=false)
public class LPHttpProtocolConfiguration {
    @Bean
    @Scope(scopeName="prototype")
    public HttpProtocol httpProtocol(GatewayContext c) {
        return new RestTemplateHttpConnection(this.httProtocolRestTemplate());
    }

    @Bean
    public ProtocolFactory<HttpProtocol> httpProtocolConnectionFactory() {
        return c -> this.httpProtocol(c);
    }

    @Bean
    public RestTemplate httProtocolRestTemplate() {
        return new RestTemplate();
    }
}

