/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.configuration.protocol;

import org.ametiste.laplatform.sdk.protocol.GatewayContext;
import org.ametiste.laplatform.sdk.protocol.ProtocolFactory;
import org.ametiste.routine.application.service.issue.TaskIssueService;
import org.ametiste.routine.application.service.removing.TaskRemovingService;
import org.ametiste.routine.application.service.termination.TaskTerminationService;
import org.ametiste.routine.domain.ModReportRepository;
import org.ametiste.routine.domain.ModRepository;
import org.ametiste.routine.domain.task.TaskRepository;
import org.ametiste.routine.infrastructure.protocol.moddata.DataConverter;
import org.ametiste.routine.infrastructure.protocol.moddata.DirectModDataConnection;
import org.ametiste.routine.infrastructure.protocol.modreport.DirectModReportConnection;
import org.ametiste.routine.infrastructure.protocol.taskcontrol.DirectTaskControlConnection;
import org.ametiste.routine.infrastructure.protocol.taskpool.DirectTaskPoolConnection;
import org.ametiste.routine.infrastructure.protocol.taskpool.TaskPoolProtocol;
import org.ametiste.routine.sdk.protocol.moddata.ModDataProtocol;
import org.ametiste.routine.sdk.protocol.modreport.ModReportProtocol;
import org.ametiste.routine.sdk.protocol.taskcontrol.TaskControlProtocol;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.convert.ConversionService;

@Configuration
public class LPCoreProtocolsConfiguration {
    @Autowired
    private TaskIssueService taskIssueService;
    @Autowired
    private ModRepository modRepository;
    @Autowired
    private ModReportRepository modReportRepository;
    @Autowired
    private TaskTerminationService taskTerminationService;
    @Autowired
    private TaskRemovingService taskRemovingService;
    @Autowired
    private TaskRepository taskRepository;
    @Autowired
    private ConversionService conversionService;

    @Bean
    @Scope(scopeName="prototype")
    public TaskPoolProtocol taskPoolProtocol(GatewayContext c) {
        return new DirectTaskPoolConnection(c.lookupAttribute("clientId"), this.taskIssueService, this.taskRemovingService);
    }

    @Bean
    @Scope(scopeName="prototype")
    public TaskControlProtocol taskControlProtocol(GatewayContext c) {
        return new DirectTaskControlConnection(c.lookupAttribute("clientId"), this.taskTerminationService);
    }

    @Bean
    @Scope(scopeName="prototype")
    public ModDataProtocol modDataProtocol(GatewayContext c) {
        return new DirectModDataConnection(c.lookupAttribute("clientId"), this.modRepository, this.modDataDataConverter());
    }

    @Bean
    public DataConverter modDataDataConverter() {
        return new DataConverter(){

            public <T> T convert(Object value, Class<T> type) {
                return (T)LPCoreProtocolsConfiguration.this.conversionService.convert(value, type);
            }
        };
    }

    @Bean
    @Scope(scopeName="prototype")
    public ModReportProtocol modReportProtocol(GatewayContext c) {
        return new DirectModReportConnection(c.lookupAttribute("clientId"), this.modReportRepository);
    }

    @Bean
    public ProtocolFactory<TaskPoolProtocol> taskPoolProtocolConnectionFactory() {
        return c -> this.taskPoolProtocol(c);
    }

    @Bean
    public ProtocolFactory<ModDataProtocol> modDataProtocolConnectionFactory() {
        return c -> this.modDataProtocol(c);
    }

    @Bean
    public ProtocolFactory<TaskControlProtocol> taskControlProtocolConnectionFactory() {
        return c -> this.taskControlProtocol(c);
    }

    @Bean
    public ProtocolFactory<ModReportProtocol> modReportProtocolConnectionFactory() {
        return c -> this.modReportProtocol(c);
    }
}

