/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.persistency.memory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ametiste.routine.domain.scheme.TaskScheme;
import org.ametiste.routine.domain.scheme.TaskSchemeRepository;

public class InMemoryTaskSchemeRepository
implements TaskSchemeRepository {
    private final Map<String, TaskScheme> schemas;

    public InMemoryTaskSchemeRepository(Map<String, TaskScheme> schemas) {
        this.schemas = schemas;
    }

    public TaskScheme findTaskScheme(String taskSchemeName) {
        if (!this.schemas.containsKey(taskSchemeName)) {
            throw new IllegalArgumentException("Can't find registered scheme with the given name: " + taskSchemeName);
        }
        return this.schemas.get(taskSchemeName);
    }

    public List<String> loadSchemeNames() {
        return new ArrayList<String>(this.schemas.keySet());
    }
}

