/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.persistency.memory;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.ametiste.routine.domain.task.Task;
import org.ametiste.routine.domain.task.TaskRepository;
import org.ametiste.routine.domain.task.notices.Notice;
import org.ametiste.routine.domain.task.reflect.OperationFlare;
import org.ametiste.routine.domain.task.reflect.TaskReflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryTaskRepository
implements TaskRepository {
    private Map<UUID, ReentrantLock> transactions = new ConcurrentHashMap<UUID, ReentrantLock>();
    private Map<UUID, InMemoryTaskReflection> reflections = new HashMap<UUID, InMemoryTaskReflection>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Task findTask(UUID taskId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Trying to find task : " + taskId.toString());
        }
        if (this.transactions.containsKey(taskId)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Locking task : " + taskId.toString());
            }
            this.transactions.get(taskId).lock();
        }
        if (this.reflections.containsKey(taskId)) {
            return new Task((TaskReflection)this.reflections.get(taskId));
        }
        if (this.transactions.containsKey(taskId)) {
            this.transactions.get(taskId).unlock();
        }
        throw new RuntimeException("Can't find task.");
    }

    public List<Task> findTasksByState(Task.State state, int limit) {
        throw new RuntimeException("Not implemented yet.");
    }

    public void saveTask(Task task) {
        if (this.transactions.containsKey(task.entityId())) {
            if (!this.transactions.get(task.entityId()).isHeldByCurrentThread()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Locking task : " + task.entityId().toString());
                }
                this.transactions.get(task.entityId()).lock();
            }
        } else {
            ReentrantLock lock = new ReentrantLock();
            lock.lock();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Locking task : " + task.entityId().toString());
            }
            this.transactions.put(task.entityId(), lock);
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Saving task : " + task.entityId().toString());
            }
            InMemoryTaskReflection taskReflection = new InMemoryTaskReflection();
            task.reflectAs((TaskReflection)taskReflection);
            this.reflections.put(taskReflection.flashTaskId(), taskReflection);
            if (taskReflection.flashTaskState().equals((Object)Task.State.NEW)) {
                // empty if block
            }
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Unlocking task : " + task.entityId().toString());
            }
            this.transactions.get(task.entityId()).unlock();
        }
    }

    public Task findTaskByOperationId(UUID operationId) {
        for (InMemoryTaskReflection taskReflection : this.reflections.values()) {
            for (OperationFlare operationFlare : taskReflection.flashOperation()) {
                if (!operationFlare.flashId().equals(operationId)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Trying to load task : " + taskReflection.flashTaskId());
                }
                if (!this.transactions.containsKey(taskReflection.flashTaskId())) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Locking task : " + taskReflection.flashTaskId());
                }
                this.transactions.get(taskReflection.flashTaskId()).lock();
                return new Task((TaskReflection)this.reflections.get(taskReflection.flashTaskId()));
            }
        }
        throw new RuntimeException("Task not found.");
    }

    private static class InMemoryTaskReflection
    implements TaskReflection {
        UUID taskId;
        Task.State state;
        List<OperationFlare> operations = new ArrayList<OperationFlare>();
        Map<String, String> properties = new HashMap<String, String>();
        Instant creationTime;
        Instant executionStartTime;
        Instant completionTime;
        List<Notice> notices = new ArrayList<Notice>();

        private InMemoryTaskReflection() {
        }

        public void flareTaskId(UUID taskId) {
            this.taskId = taskId;
        }

        public void flareTaskState(Task.State state) {
            this.state = state;
        }

        public void flareOperation(OperationFlare operationFlare) {
            this.operations.add(operationFlare);
        }

        public void flareProperty(String name, String value) {
            this.properties.put(name, value);
        }

        public void flareTaskTimes(Instant creationTime, Instant executionStartTime, Instant completionTime) {
            this.creationTime = creationTime;
            this.executionStartTime = executionStartTime;
            this.completionTime = completionTime;
        }

        public void reflect(TaskReflection reflection) {
            reflection.flareTaskId(this.taskId);
            reflection.flareTaskState(this.state);
            reflection.flareTaskTimes(this.creationTime, this.executionStartTime, this.completionTime);
            this.notices.forEach(arg_0 -> ((TaskReflection)reflection).flareNotice(arg_0));
            this.operations.forEach(arg_0 -> ((TaskReflection)reflection).flareOperation(arg_0));
            this.properties.forEach((arg_0, arg_1) -> ((TaskReflection)reflection).flareProperty(arg_0, arg_1));
        }

        public void flareNotice(Notice notice) {
            this.notices.add(notice);
        }

        public UUID flashTaskId() {
            return this.taskId;
        }

        public Task.State flashTaskState() {
            return this.state;
        }

        public Collection<OperationFlare> flashOperation() {
            return Collections.unmodifiableCollection(this.operations);
        }

        public Map<String, String> flashProperties() {
            return Collections.unmodifiableMap(this.properties);
        }
    }
}

