/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.persistency.jdbc.reflection;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ametiste.routine.domain.task.Task;
import org.ametiste.routine.infrastructure.persistency.ClosedTaskReflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.SqlLobValue;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.util.SerializationUtils;

public class JdbcTaskReflection
extends ClosedTaskReflection {
    private static final String saveTaskQuery = "INSERT INTO %s (id, state, cr_time, execs_time, co_time, agregate) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String checkExistsTaskQuery = "SELECT COUNT(*) FROM %s WHERE id = ?";
    private static final String updateTaskQuery = "UPDATE %s SET state=?, execs_time=?, co_time=?, agregate=? WHERE id = ?";
    private static final String saveTaskOperationQuery = "INSERT INTO %s (id, task_id) VALUES (?, ?)";
    private static final String saveTaskPropertiesQuery = "INSERT INTO ame_routine.ame_routine_task_property (task_id, name, value) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE value=VALUES(value)";
    private final String taskTable;
    private final String operationTable;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private RowMapper<ClosedTaskReflection.ReflectedTaskData> taskDataRowMapper = new RowMapper<ClosedTaskReflection.ReflectedTaskData>(){

        public ClosedTaskReflection.ReflectedTaskData mapRow(ResultSet rs, int rowNum) throws SQLException {
            DefaultLobHandler lobHandler = new DefaultLobHandler();
            byte[] bytes = lobHandler.getBlobAsBytes(rs, "agregate");
            return (ClosedTaskReflection.ReflectedTaskData)ClosedTaskReflection.ReflectedTaskData.class.cast(SerializationUtils.deserialize((byte[])bytes));
        }
    };
    private final JdbcTemplate jdbcTemplate;

    public JdbcTaskReflection(String taskTable, String operationTable, UUID taskId, JdbcTemplate jdbcTemplate) {
        this(taskTable, operationTable, jdbcTemplate);
        this.flareTaskId(taskId);
    }

    public JdbcTaskReflection(String taskTable, String operationTable, JdbcTemplate jdbcTemplate, ClosedTaskReflection.ReflectedTaskData reflectedTaskData) {
        this(taskTable, operationTable, jdbcTemplate);
        this.flareTaskId(reflectedTaskData.taskId);
        this.reflectedTaskData = reflectedTaskData;
    }

    public JdbcTaskReflection(String taskTable, String operationTable, JdbcTemplate jdbcTemplate) {
        if (jdbcTemplate == null) {
            throw new IllegalArgumentException("jdbcTemplate can't be null");
        }
        if (taskTable == null || taskTable.isEmpty()) {
            throw new IllegalArgumentException("taskTable can't be nul nor empty");
        }
        if (operationTable == null || operationTable.isEmpty()) {
            throw new IllegalArgumentException("operationTable can't be nul nor empty");
        }
        this.taskTable = taskTable;
        this.operationTable = operationTable;
        this.jdbcTemplate = jdbcTemplate;
    }

    public void loadReflection() {
        this.reflectedTaskData = (ClosedTaskReflection.ReflectedTaskData)this.jdbcTemplate.queryForObject(String.format("SELECT agregate FROM %s WHERE id = ?", this.taskTable), this.taskDataRowMapper, new Object[]{this.reflectedTaskData.taskId.toString()});
    }

    public <T> List<T> loadMultipleReflections(Function<ClosedTaskReflection.ReflectedTaskData, T> taskReflectionConsumer, int offset, int limit) {
        List reflectedData = this.jdbcTemplate.query(String.format("SELECT agregate FROM %s ORDER BY cr_time DESC LIMIT ?, ?", this.taskTable), this.taskDataRowMapper, new Object[]{offset, limit});
        List processed = reflectedData.stream().map(taskReflectionConsumer::apply).collect(Collectors.toList());
        return processed;
    }

    public <T> List<T> loadMultipleReflections(Function<ClosedTaskReflection.ReflectedTaskData, T> taskReflectionConsumer, String status, int offset, int limit) {
        List reflectedData = this.jdbcTemplate.query(String.format("SELECT agregate FROM %s WHERE state = ? ORDER BY cr_time DESC LIMIT ?, ?", this.taskTable), this.taskDataRowMapper, new Object[]{status, offset, limit});
        List processed = reflectedData.stream().map(taskReflectionConsumer::apply).collect(Collectors.toList());
        return processed;
    }

    public <T> List<T> loadMultipleReflectionsAs(String query, Function<ClosedTaskReflection.ReflectedTaskData, T> taskReflectionConsumer) {
        List reflectedData = this.jdbcTemplate.query(query, this.taskDataRowMapper);
        List processed = reflectedData.stream().map(taskReflectionConsumer::apply).collect(Collectors.toList());
        return processed;
    }

    public List<JdbcTaskReflection> loadMultipleReflectionsByState(Task.State state, int offset, int limit) {
        List reflectedData = this.jdbcTemplate.query(String.format("SELECT agregate FROM %s WHERE state = ? ORDER BY cr_time DESC LIMIT ?, ?", this.taskTable), this.taskDataRowMapper, new Object[]{state.name(), offset, limit});
        return reflectedData.stream().map(d -> new JdbcTaskReflection(this.taskTable, this.operationTable, this.jdbcTemplate, (ClosedTaskReflection.ReflectedTaskData)d)).collect(Collectors.toList());
    }

    public <T> T processReflection(Function<ClosedTaskReflection.ReflectedTaskData, T> taskReflectionConsumer) {
        this.loadReflection();
        return taskReflectionConsumer.apply(this.reflectedTaskData);
    }

    public void saveReflection() {
        DefaultLobHandler lobHandler = new DefaultLobHandler();
        byte[] data = SerializationUtils.serialize((Object)this.reflectedTaskData);
        if (this.isRecordExists()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("----");
                this.logger.debug("Update task  : " + this.reflectedTaskData.taskId);
                this.logger.debug("       state : " + this.reflectedTaskData.state);
                this.logger.debug("----");
            }
            this.jdbcTemplate.update(String.format(updateTaskQuery, this.taskTable), new Object[]{this.reflectedTaskData.state.name(), Optional.ofNullable(this.reflectedTaskData.executionStartTime).map(Timestamp::from).orElse(null), Optional.ofNullable(this.reflectedTaskData.completionTime).map(Timestamp::from).orElse(null), new SqlLobValue(data, (LobHandler)lobHandler), this.reflectedTaskData.taskId.toString()}, new int[]{12, 93, 93, 2004, 12});
            this.reflectedTaskData.properties.forEach((k, v) -> this.jdbcTemplate.update(saveTaskPropertiesQuery, new Object[]{this.reflectedTaskData.taskId.toString(), k, v}, new int[]{12, 12, 12}));
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("----");
                this.logger.debug("Save task  : " + this.reflectedTaskData.taskId);
                this.logger.debug("       state : " + this.reflectedTaskData.state);
                this.logger.debug("----");
            }
            this.jdbcTemplate.update(String.format(saveTaskQuery, this.taskTable), new Object[]{this.reflectedTaskData.taskId.toString(), this.reflectedTaskData.state.name(), Optional.ofNullable(this.reflectedTaskData.creationTime).map(Timestamp::from).orElse(null), Optional.ofNullable(this.reflectedTaskData.executionStartTime).map(Timestamp::from).orElse(null), Optional.ofNullable(this.reflectedTaskData.completionTime).map(Timestamp::from).orElse(null), new SqlLobValue(data, (LobHandler)lobHandler)}, new int[]{12, 12, 93, 93, 93, 2004});
            this.reflectedTaskData.properties.forEach((k, v) -> this.jdbcTemplate.update(saveTaskPropertiesQuery, new Object[]{this.reflectedTaskData.taskId.toString(), k, v}, new int[]{12, 12, 12}));
            this.reflectedTaskData.operationFlare.forEach(o -> this.jdbcTemplate.update(String.format(saveTaskOperationQuery, this.operationTable), new Object[]{o.flashId().toString(), this.reflectedTaskData.taskId.toString()}));
        }
    }

    private boolean isRecordExists() {
        return (Integer)this.jdbcTemplate.queryForObject(String.format(checkExistsTaskQuery, this.taskTable), Integer.class, new Object[]{this.reflectedTaskData.taskId.toString()}) > 0;
    }
}

