/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.persistency.jdbc;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.ametiste.routine.domain.task.Task;
import org.ametiste.routine.domain.task.TaskRepository;
import org.ametiste.routine.domain.task.reflect.TaskReflection;
import org.ametiste.routine.infrastructure.persistency.jdbc.reflection.JdbcTaskReflection;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcTaskRepository
implements TaskRepository {
    private JdbcTemplate jdbcTemplate;
    private String taskTable;
    private String operationTable;

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setTaskTable(String taskTable) {
        this.taskTable = taskTable;
    }

    public void setOperationTable(String operationTable) {
        this.operationTable = operationTable;
    }

    public Task findTask(UUID taskId) {
        JdbcTaskReflection jdbcTaskReflection = new JdbcTaskReflection(this.taskTable, this.operationTable, taskId, this.jdbcTemplate);
        jdbcTaskReflection.loadReflection();
        return new Task((TaskReflection)jdbcTaskReflection);
    }

    public List<Task> findTasksByState(Task.State state, int limit) {
        List<JdbcTaskReflection> reflectedTaskDatas = new JdbcTaskReflection(this.taskTable, this.operationTable, this.jdbcTemplate).loadMultipleReflectionsByState(state, 0, limit);
        return reflectedTaskDatas.stream().map(r -> new Task((TaskReflection)r)).collect(Collectors.toList());
    }

    public void saveTask(Task task) {
        JdbcTaskReflection jdbcTaskReflection = new JdbcTaskReflection(this.taskTable, this.operationTable, task.entityId(), this.jdbcTemplate);
        task.reflectAs((TaskReflection)jdbcTaskReflection);
        jdbcTaskReflection.saveReflection();
    }

    public Task findTaskByOperationId(UUID operationId) {
        String taskId = (String)this.jdbcTemplate.queryForObject(String.format("SELECT task_id FROM %s WHERE id = ? FOR UPDATE", this.operationTable), String.class, new Object[]{operationId.toString()});
        if (taskId == null) {
            throw new RuntimeException("Task not found by operation id: " + operationId.toString());
        }
        JdbcTaskReflection jdbcTaskReflection = new JdbcTaskReflection(this.taskTable, this.operationTable, UUID.fromString(taskId), this.jdbcTemplate);
        jdbcTaskReflection.loadReflection();
        return new Task((TaskReflection)jdbcTaskReflection);
    }
}

