/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.persistency;

import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.ametiste.routine.domain.task.Task;
import org.ametiste.routine.domain.task.notices.Notice;
import org.ametiste.routine.domain.task.reflect.OperationFlare;
import org.ametiste.routine.domain.task.reflect.TaskReflection;

public abstract class ClosedTaskReflection
implements TaskReflection {
    protected ReflectedTaskData reflectedTaskData = new ReflectedTaskData();

    public void flareTaskId(UUID taskId) {
        this.reflectedTaskData.taskId = taskId;
    }

    public void flareTaskState(Task.State state) {
        this.reflectedTaskData.state = state;
    }

    public void flareOperation(OperationFlare operationFlare) {
        this.reflectedTaskData.operationFlare.add(operationFlare);
    }

    public void flareProperty(String name, String value) {
        this.reflectedTaskData.properties.put(name, value);
    }

    public void flareTaskTimes(Instant creationTime, Instant executionStartTime, Instant completionTime) {
        this.reflectedTaskData.creationTime = creationTime;
        this.reflectedTaskData.executionStartTime = executionStartTime;
        this.reflectedTaskData.completionTime = completionTime;
    }

    public void flareNotice(Notice notice) {
        this.reflectedTaskData.notices.add(notice);
    }

    public void reflect(TaskReflection reflection) {
        reflection.flareTaskId(this.reflectedTaskData.taskId);
        reflection.flareTaskTimes(this.reflectedTaskData.creationTime, this.reflectedTaskData.executionStartTime, this.reflectedTaskData.completionTime);
        reflection.flareTaskState(this.reflectedTaskData.state);
        this.reflectedTaskData.operationFlare.forEach(arg_0 -> ((TaskReflection)reflection).flareOperation(arg_0));
        this.reflectedTaskData.notices.forEach(arg_0 -> ((TaskReflection)reflection).flareNotice(arg_0));
        this.reflectedTaskData.properties.forEach((arg_0, arg_1) -> ((TaskReflection)reflection).flareProperty(arg_0, arg_1));
    }

    public static class ReflectedTaskData
    implements Serializable {
        public UUID taskId;
        public Task.State state;
        public List<OperationFlare> operationFlare = new ArrayList<OperationFlare>();
        public Map<String, String> properties = new HashMap<String, String>();
        public Instant creationTime;
        public Instant executionStartTime;
        public Instant completionTime;
        public List<Notice> notices = new ArrayList<Notice>();
    }
}

