/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.mod;

import java.util.Optional;
import org.ametiste.routine.infrastructure.mod.ModDataRepository;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcModDataRepository
implements ModDataRepository {
    private final JdbcTemplate jdbcTemplate;

    public JdbcModDataRepository(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public void saveModProperty(String modId, String name, String value) {
        this.jdbcTemplate.update("INSERT INTO ame_routine.ame_routine_mod_property (mod_id, name, value) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE value = VALUES(value)", new Object[]{modId, name, value});
    }

    @Override
    public Optional<String> loadModProperty(String modId, String name) {
        try {
            return Optional.of(this.jdbcTemplate.queryForObject("SELECT value FROM ame_routine.ame_routine_mod_property WHERE mod_id = ? AND name = ?", String.class, new Object[]{modId, name}));
        }
        catch (EmptyResultDataAccessException e) {
            return Optional.empty();
        }
    }
}

