/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.infrastructure.messaging;

import java.util.UUID;
import java.util.concurrent.Executors;
import org.ametiste.routine.application.service.execution.ExecutionFeedback;
import org.ametiste.routine.application.service.execution.OperationExecutionGateway;
import org.ametiste.routine.application.service.execution.TaskExecutionService;
import org.ametiste.routine.domain.task.ExecutionLine;
import org.ametiste.routine.domain.task.ExecutionOrder;
import org.ametiste.routine.infrastructure.messaging.BoundedExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.annotation.JmsListener;

public class JmsTaskEventsListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TaskExecutionService taskExecutionService;
    private final ExecutionFeedback executionFeedback;
    private final OperationExecutionGateway executionManager;
    private final BoundedExecutor boundedExecutor;

    public JmsTaskEventsListener(TaskExecutionService taskExecutionService, ExecutionFeedback executionFeedback, OperationExecutionGateway executionManager, int concurrencyLevel) {
        this.taskExecutionService = taskExecutionService;
        this.executionFeedback = executionFeedback;
        this.executionManager = executionManager;
        this.boundedExecutor = new BoundedExecutor(Executors.newFixedThreadPool(concurrencyLevel), concurrencyLevel);
    }

    @JmsListener(destination="task-issued")
    public void onTaskIssued(UUID taskId) throws Exception {
        this.boundedExecutor.submitTask(() -> {
            block2: {
                try {
                    this.taskExecutionService.executeTask(taskId);
                }
                catch (Exception e) {
                    if (!this.logger.isDebugEnabled()) break block2;
                    this.logger.debug("Error during task execution.", (Throwable)e);
                }
            }
        });
    }

    @JmsListener(destination="task-pended")
    public void onTaskPended(ExecutionOrder executionOrder) throws Exception {
        this.boundedExecutor.submitTask(() -> {
            for (ExecutionLine line : executionOrder.executionLines()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Pass execution line to operations service: {}", (Object)line.line());
                }
                this.executionManager.executeOperation(line.operationId(), line.line(), line.properties(), this.executionFeedback);
            }
        });
    }
}

