/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.routine.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametiste.routine.application.service.TaskAppEvenets;
import org.ametiste.routine.application.service.execution.DefaultTaskExecutionService;
import org.ametiste.routine.application.service.execution.ExecutionFeedback;
import org.ametiste.routine.application.service.execution.OperationExecutionGateway;
import org.ametiste.routine.application.service.execution.TaskExecutionService;
import org.ametiste.routine.application.service.issue.DefaultTaskIssueService;
import org.ametiste.routine.application.service.issue.TaskIssueService;
import org.ametiste.routine.configuration.AmetisteRoutineCoreProperties;
import org.ametiste.routine.configuration.JdbcTaskRepositoryConfiguration;
import org.ametiste.routine.configuration.TaskSchemeRepositoryConfiguration;
import org.ametiste.routine.domain.scheme.TaskSchemeRepository;
import org.ametiste.routine.domain.task.TaskRepository;
import org.ametiste.routine.domain.task.properties.TaskPropertiesRegistry;
import org.ametiste.routine.domain.task.properties.TaskProperty;
import org.ametiste.routine.infrastructure.execution.DefaultOperationExecutionGateway;
import org.ametiste.routine.infrastructure.messaging.JmsTaskAppEvents;
import org.ametiste.routine.infrastructure.messaging.JmsTaskEventsListener;
import org.ametiste.routine.infrastructure.mod.JdbcModDataRepository;
import org.ametiste.routine.infrastructure.mod.ModDataRepository;
import org.ametiste.routine.interfaces.web.TaskController;
import org.ametiste.routine.sdk.application.service.issue.constraints.IssueConstraint;
import org.ametiste.routine.sdk.operation.OperationExecutor;
import org.ametiste.routine.sdk.operation.OperationExecutorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jms.core.JmsTemplate;

@Configuration
@Import(value={JdbcTaskRepositoryConfiguration.class, TaskSchemeRepositoryConfiguration.class})
@ComponentScan(basePackageClasses={TaskController.class})
@EnableConfigurationProperties(value={AmetisteRoutineCoreProperties.class})
public class AmetisteRoutineCoreConfiguration {
    @Autowired
    private TaskRepository taskRepository;
    @Autowired(required=false)
    private List<IssueConstraint> issueConstraints;
    @Autowired
    private TaskPropertiesRegistry taskPropertiesRegistry;
    @Autowired
    private TaskSchemeRepository taskSchemeRepository;
    @Autowired
    private JmsTemplate jmsTemplate;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired(required=false)
    private Map<String, OperationExecutorFactory> operationExecutorFactories = Collections.emptyMap();
    @Autowired(required=false)
    private Map<String, OperationExecutor> operationExecutors = Collections.emptyMap();
    @Autowired
    private AmetisteRoutineCoreProperties props;

    @Bean
    public TaskIssueService taskIssueService() {
        return new DefaultTaskIssueService(this.taskRepository, this.taskPropertiesRegistry, this.taskSchemeRepository, this.taskAppEvenets(), this.issueConstraints);
    }

    @Bean
    public ModDataRepository modDataRepository() {
        return new JdbcModDataRepository(this.jdbcTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public OperationExecutionGateway operationExecutionGateway() {
        HashMap<String, OperationExecutorFactory> factories = new HashMap<String, OperationExecutorFactory>();
        factories.putAll(this.operationExecutorFactories);
        this.operationExecutors.entrySet().stream().forEach(k -> factories.put((String)k.getKey(), () -> (OperationExecutor)k.getValue()));
        return new DefaultOperationExecutionGateway(factories);
    }

    @Bean
    @ConditionalOnMissingBean
    public DefaultTaskExecutionService taskExecutionService() {
        return new DefaultTaskExecutionService(this.taskRepository, this.taskAppEvenets(), this.operationExecutionGateway());
    }

    @Bean
    @ConditionalOnMissingBean
    public TaskAppEvenets taskAppEvenets() {
        return new JmsTaskAppEvents(this.jmsTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public JmsTaskEventsListener issuedTaskEventListener() {
        return new JmsTaskEventsListener((TaskExecutionService)this.taskExecutionService(), (ExecutionFeedback)this.taskExecutionService(), this.operationExecutionGateway(), this.props.getInitialExecutionConcurrency());
    }

    @Bean
    @ConditionalOnMissingBean
    public TaskPropertiesRegistry taskPropertiesRegistry() {
        return new TaskPropertiesRegistry(){

            public TaskProperty createTaskProperty(String kind, String value) {
                return null;
            }
        };
    }
}

