/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.rest.client.leap;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.ametiste.rest.client.Representation;
import org.ametiste.rest.client.Transition;
import org.ametiste.rest.client.leap.ShapelessData;
import org.springframework.hateoas.Link;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class LeapRepresentation
implements Representation {
    private Map<String, String> relationToUri;
    private RestTemplate rt;
    private MediaType type;

    public LeapRepresentation(ShapelessData data, MediaType defaultJumpType, RestTemplate rt) {
        this.type = defaultJumpType;
        this.rt = rt;
        this.relationToUri = new HashMap<String, String>();
        for (Link link : data.getLinks()) {
            this.relationToUri.put(link.getRel(), link.getHref());
        }
    }

    public Representation jump(String rel) {
        if (!this.relationToUri.containsKey(rel)) {
            throw new IllegalArgumentException("No such relation in representation");
        }
        Transition<ShapelessData> t = this.buildLeap(rel);
        ShapelessData data = this.load(t, this.relationToUri.get(rel));
        return new LeapRepresentation(data, this.type, this.rt);
    }

    private Transition<ShapelessData> buildLeap(final String relation) {
        return new Transition<ShapelessData>(){

            public MediaType getMediaType() {
                return LeapRepresentation.this.type;
            }

            public HttpMethod getMethod() {
                return HttpMethod.GET;
            }

            public Class<ShapelessData> getResponseType() {
                return ShapelessData.class;
            }

            public String getRelation() {
                return relation;
            }
        };
    }

    public <E> E exec(Transition<E> rel) {
        if (!this.relationToUri.containsKey(rel.getRelation())) {
            throw new IllegalArgumentException("No such relation in representation");
        }
        String href = this.relationToUri.get(rel.getRelation());
        E reply = this.load(rel, href);
        return reply;
    }

    private <E> E load(Transition<E> rel, String href) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(rel.getMediaType()));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        return (E)this.rt.exchange(href, rel.getMethod(), entity, rel.getResponseType(), new Object[0]).getBody();
    }
}

