/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.metrics.boot.configuration.routing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametiste.metrics.MetricsAggregator;
import org.ametiste.metrics.boot.configuration.routing.Route;

public class RouteConfiguration {
    private Map<String, List<MetricsAggregator>> routing = new HashMap<String, List<MetricsAggregator>>();

    public RouteConfiguration(List<Route> routes) {
        if (routes == null) {
            throw new IllegalArgumentException("Routes list can't be null.");
        }
        routes.forEach(this::assign);
        this.routing = Collections.unmodifiableMap(this.routing);
    }

    public RouteConfiguration(Route ... routes) {
        this(Arrays.asList(routes));
    }

    public Map<String, List<MetricsAggregator>> asMap() {
        return this.routing;
    }

    private void assign(Route route) {
        this.routing.computeIfAbsent(route.path, k -> new ArrayList()).addAll(route.assigned);
    }
}

