/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.metrics.boot.configuration;

import org.ametiste.metrics.AggregatingMetricsService;
import org.ametiste.metrics.MetricsService;
import org.ametiste.metrics.aop.IdentifierResolver;
import org.ametiste.metrics.boot.configuration.CoreIdentifierResolver;
import org.ametiste.metrics.boot.configuration.DefaultRoutingConfiguration;
import org.ametiste.metrics.boot.configuration.EmptyAggregatorsConfiguration;
import org.ametiste.metrics.boot.configuration.MetricsIdentifierResolverCoreConfguration;
import org.ametiste.metrics.boot.configuration.MetricsProperties;
import org.ametiste.metrics.boot.configuration.MetricsRoutingCoreConfiguration;
import org.ametiste.metrics.resolver.MetricsIdentifierResolver;
import org.ametiste.metrics.router.AggregatorsRouter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

@Configuration
@Import(value={EmptyAggregatorsConfiguration.class, DefaultRoutingConfiguration.class, MetricsRoutingCoreConfiguration.class, MetricsIdentifierResolverCoreConfguration.class})
@EnableConfigurationProperties(value={MetricsProperties.class})
public class MetricsServiceConfiguration {
    @Autowired
    private MetricsProperties properties;
    @Autowired
    private AggregatorsRouter aggregatorsRouter;
    @Autowired
    @CoreIdentifierResolver
    private MetricsIdentifierResolver identifierResolver;

    @Bean
    @Qualifier(value="metricsService")
    @ConditionalOnMissingBean
    public MetricsService metricsService() {
        return new AggregatingMetricsService(this.aggregatorsRouter, this.identifierResolver, this.properties.getPrefix());
    }

    @Bean
    public SpelExpressionParser spelParser() {
        return new SpelExpressionParser();
    }

    @Bean
    public IdentifierResolver nameResolver() {
        return new IdentifierResolver((ExpressionParser)this.spelParser());
    }
}

