/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.metrics.boot.configuration;

import org.ametiste.metrics.MetricsService;
import org.ametiste.metrics.aop.ChronableAspect;
import org.ametiste.metrics.aop.CountableAspect;
import org.ametiste.metrics.aop.ErrorCountableAspect;
import org.ametiste.metrics.aop.IdentifierResolver;
import org.ametiste.metrics.aop.TimeableAspect;
import org.ametiste.metrics.boot.configuration.MetricsServiceConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

@Configuration
@Import(value={MetricsServiceConfiguration.class})
public class MetricsCoreConfiguration {
    @Autowired
    private MetricsService metricsService;
    @Autowired
    private SpelExpressionParser spelParser;
    @Autowired
    private IdentifierResolver nameResolver;

    @Bean
    public TimeableAspect timeableAspect() {
        return new TimeableAspect(this.metricsService, this.nameResolver);
    }

    @Bean
    public CountableAspect countableAspect() {
        return new CountableAspect(this.metricsService, this.nameResolver);
    }

    @Bean
    public ErrorCountableAspect errorCountableAspect() {
        return new ErrorCountableAspect(this.metricsService, this.nameResolver);
    }

    @Bean
    public ChronableAspect chronableAspect() {
        return new ChronableAspect(this.metricsService, this.nameResolver, (ExpressionParser)this.spelParser);
    }
}

