/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.metrics.router;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.ametiste.metrics.MetricsAggregator;
import org.ametiste.metrics.router.AggregatorsRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingAggregatorsRouter
implements AggregatorsRouter {
    public static final String DEFAULT_ROUTE_NAME = "__default";
    private final Map<String, List<MetricsAggregator>> aggregatorsMap;
    private boolean hasWildCards = false;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public MappingAggregatorsRouter(Map<String, List<MetricsAggregator>> aggregators) {
        if (aggregators == null || !aggregators.containsKey(DEFAULT_ROUTE_NAME)) {
            throw new IllegalArgumentException("Default routing should be set, use key '__default'");
        }
        aggregators.keySet().stream().filter(key -> key.contains("*")).findAny().ifPresent(wildcard -> {
            this.hasWildCards = true;
        });
        this.aggregatorsMap = aggregators;
    }

    @Override
    @Deprecated
    public List<MetricsAggregator> getAggregatorsForMetric(String metricIdentifier) {
        if (this.aggregatorsMap.containsKey(metricIdentifier)) {
            return this.aggregatorsMap.get(metricIdentifier);
        }
        if (this.hasWildCards) {
            return this.aggregatorsMap.keySet().stream().filter(key -> key.contains("*") && metricIdentifier.startsWith(key.replace("*", ""))).findFirst().map(this.aggregatorsMap::get).orElse(this.aggregatorsMap.get(DEFAULT_ROUTE_NAME));
        }
        return this.aggregatorsMap.get(DEFAULT_ROUTE_NAME);
    }

    @Override
    public void aggregate(String metricIdentifier, Consumer<MetricsAggregator> function) {
        this.getAggregatorsForMetric(metricIdentifier).forEach(a -> {
            try {
                function.accept((MetricsAggregator)a);
            }
            catch (Exception e) {
                this.logger.debug("Aggregator threw exception. Aggregator: " + a.getClass(), (Throwable)e);
            }
        });
    }
}

