/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.metrics.resolver;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametiste.metrics.resolver.MetricsIdentifierResolver;

public class PathMetricsIdentifierResolver
implements MetricsIdentifierResolver {
    private final Map<String, String> pathsToId;
    private final String defaultIdentifier;

    public PathMetricsIdentifierResolver(List<String> paths, String defaultIdentifier) {
        if (defaultIdentifier == null || defaultIdentifier.isEmpty()) {
            throw new IllegalArgumentException("Default metric identifier cant be empty or null");
        }
        if (paths == null) {
            throw new IllegalArgumentException("Paths cant be null. Use empty list if required");
        }
        this.defaultIdentifier = defaultIdentifier;
        this.pathsToId = new HashMap<String, String>();
        for (String path : paths) {
            String trimmed = this.trimEnclosingPath(path);
            this.pathsToId.put(trimmed, this.fitName(trimmed));
        }
    }

    private String fitName(String path) {
        return path.replaceAll("/", ".");
    }

    @Override
    public String resolveMetricId(String metricName) {
        return this.pathsToId.getOrDefault(this.trimEnclosingPath(metricName), this.defaultIdentifier);
    }

    private String trimEnclosingPath(String path) {
        String trimedPath = path;
        if (trimedPath.startsWith("/")) {
            trimedPath = trimedPath.replaceFirst("/", "");
        }
        if (trimedPath.endsWith("/")) {
            trimedPath = trimedPath.substring(0, trimedPath.length() - 1);
        }
        return trimedPath;
    }
}

