/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.metrics;

import java.util.function.Consumer;
import org.ametiste.metrics.MetricsAggregator;
import org.ametiste.metrics.MetricsService;
import org.ametiste.metrics.resolver.MetricsIdentifierResolver;
import org.ametiste.metrics.router.AggregatorsRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatingMetricsService
implements MetricsService {
    private static final String DELIMITER = ".";
    private MetricsIdentifierResolver resolver;
    private String prefix = "";
    private AggregatorsRouter router;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public AggregatingMetricsService(AggregatorsRouter router, MetricsIdentifierResolver resolver, String prefix) {
        if (router == null) {
            throw new IllegalArgumentException("Router can not be null");
        }
        if (resolver == null) {
            throw new IllegalArgumentException("Resolver can not be null");
        }
        this.resolver = resolver;
        this.router = router;
        if (prefix != null) {
            this.prefix = prefix;
        }
    }

    @Override
    public void increment(String metricId, int incrementValue) {
        this.route(metricId, metricAggregator -> metricAggregator.increment(this.resolve(metricId), incrementValue));
    }

    @Override
    public void gauge(String metricId, int gaugeValue) {
        this.route(metricId, metricAggregator -> metricAggregator.gauge(this.resolve(metricId), gaugeValue));
    }

    @Override
    public void createEvent(String metricId, int eventValue) {
        this.route(metricId, metricAggregator -> metricAggregator.event(this.resolve(metricId), eventValue));
    }

    private void route(String metricId, Consumer<MetricsAggregator> action) {
        try {
            this.router.aggregate(metricId, action);
        }
        catch (Exception e) {
            this.logger.debug("Router threw an exception", (Throwable)e);
        }
    }

    private String resolve(String metricId) {
        return this.prefix + DELIMITER + this.resolver.resolveMetricId(metricId);
    }
}

