/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.metrics.router;

import java.util.List;
import java.util.Map;
import org.ametiste.metrics.MetricsAggregator;
import org.ametiste.metrics.container.ListContainer;
import org.ametiste.metrics.container.MapContainer;
import org.ametiste.metrics.router.AggregatorsRouter;

public class MappingAggregatorsRouter
implements AggregatorsRouter {
    private final String defaultRouteName = "__default";
    private final Map<String, ListContainer> aggregatorsMap;
    private boolean hasWildCards = false;

    public MappingAggregatorsRouter(MapContainer container) {
        if (container == null || !container.loadMap().containsKey("__default")) {
            throw new IllegalArgumentException("Default routing should be set, use key '__default'");
        }
        container.loadMap().keySet().stream().filter(key -> key.contains("*")).forEach(key -> {
            this.hasWildCards = true;
        });
        this.aggregatorsMap = container.loadMap();
    }

    @Override
    public List<MetricsAggregator> getAggregatorsForMetric(String metricIdentifier) {
        if (this.aggregatorsMap.containsKey(metricIdentifier)) {
            return this.aggregatorsMap.get(metricIdentifier).loadList();
        }
        if (this.hasWildCards) {
            for (String key : this.aggregatorsMap.keySet()) {
                if (!key.contains("*") || !metricIdentifier.startsWith(key.replace("*", ""))) continue;
                return this.aggregatorsMap.get(key).loadList();
            }
        }
        return this.aggregatorsMap.get("__default").loadList();
    }
}

