/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.metrics.resolver;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametiste.metrics.resolver.MetricsIdentifierResolver;

public class PathMetricsIdentifierResolver
implements MetricsIdentifierResolver {
    private final Map<String, String> pathsToId;
    private final String defaultIdentifier;

    public PathMetricsIdentifierResolver(List<String> paths, String defaultIdentifier) {
        this.defaultIdentifier = defaultIdentifier;
        this.pathsToId = new HashMap<String, String>();
        for (String path : paths) {
            this.pathsToId.put(path, this.fitName(path));
        }
    }

    private String fitName(String path) {
        return path.replaceAll("/", ".");
    }

    @Override
    public String resolveMetricId(String metricName) {
        if (this.pathsToId.containsKey(metricName)) {
            return this.pathsToId.get(metricName);
        }
        return this.defaultIdentifier;
    }
}

