/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.metrics.resolver;

import java.util.Map;
import org.ametiste.metrics.resolver.MetricsIdentifierResolver;

public class MappingMetricsIdentifierResolver
implements MetricsIdentifierResolver {
    private final Map<String, String> nameToIdMap;

    public MappingMetricsIdentifierResolver(Map<String, String> nameToIdMap) {
        if (nameToIdMap == null) {
            throw new IllegalArgumentException("Metrics id to name map cant be null. Use PlainMetricNameResolver if there's no need in explicit mappings");
        }
        this.nameToIdMap = nameToIdMap;
    }

    @Override
    public String resolveMetricId(String metricName) {
        if (this.nameToIdMap.containsKey(metricName)) {
            return this.nameToIdMap.get(metricName);
        }
        return metricName;
    }
}

