/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.metrics;

import org.ametiste.metrics.MetricsService;
import org.ametiste.metrics.resolver.MetricsIdentifierResolver;
import org.ametiste.metrics.router.AggregatorsRouter;

public class AggregatingMetricsService
implements MetricsService {
    private static final String DELIMITER = ".";
    private MetricsIdentifierResolver resolver;
    private String prefix = "";
    private AggregatorsRouter router;

    public AggregatingMetricsService(AggregatorsRouter router, MetricsIdentifierResolver resolver, String prefix) {
        if (router == null) {
            throw new IllegalArgumentException("Router can not be null");
        }
        if (resolver == null) {
            throw new IllegalArgumentException("Resolver can not be null");
        }
        this.resolver = resolver;
        this.router = router;
        if (prefix != null) {
            this.prefix = prefix;
        }
    }

    @Override
    public void increment(String metricId) {
        this.router.getAggregatorsForMetric(metricId).forEach(metricAggregator -> metricAggregator.increment(this.resolve(metricId)));
    }

    @Override
    public void increment(String metricId, int incrementValue) {
        this.router.getAggregatorsForMetric(metricId).forEach(metricAggregator -> metricAggregator.increment(this.resolve(metricId), incrementValue));
    }

    @Override
    @Deprecated
    public void createEvent(String metricId, long startTime, long endTime) {
        this.createEvent(metricId, (int)(endTime - startTime));
    }

    @Override
    public void createEvent(String metricId, int eventValue) {
        this.router.getAggregatorsForMetric(metricId).forEach(metricAggregator -> metricAggregator.event(this.resolve(metricId), eventValue));
    }

    private String resolve(String metricId) {
        return this.prefix + DELIMITER + this.resolver.resolveMetricId(metricId);
    }
}

