/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.metrics.mock;

import java.util.List;
import org.ametiste.metrics.mock.store.MetricsType;
import org.ametiste.metrics.mock.store.MockMetricsContainer;
import org.junit.Assert;

public class MockMetricsVerifier {
    private final String name;
    private MockMetricsContainer container;

    public MockMetricsVerifier(String name, MockMetricsContainer container) {
        this.container = container;
        this.name = name;
    }

    public MockMetricsVerifier registered() {
        Assert.assertTrue((String)("Metric with name '" + this.name + "' was expected to be registered in service, but wasnt"), (boolean)this.container.hasValueWithName(this.name));
        return this;
    }

    public void notRegistered() {
        Assert.assertFalse((String)("Metric with name '" + this.name + "' not expected to be registered by service, but actually was"), (boolean)this.container.hasValueWithName(this.name));
    }

    public MockMetricsVerifier increment() {
        Assert.assertTrue((String)("Metric with name '" + this.name + "' was expected to be registered as incremental, but wasnt"), (boolean)this.container.hasValueWithTypeAndName(MetricsType.INCR_VALUE, this.name));
        return this;
    }

    public MockMetricsVerifier increment(int times) {
        Assert.assertTrue((String)("Metric with name '" + this.name + "' was expected to be registered as incremental " + times + " times, but actually was registered " + this.container.getCountForValue(MetricsType.INCR_VALUE, this.name) + " times"), (boolean)this.container.hasValueWithTypeAndNameAndCount(MetricsType.INCR_VALUE, this.name, times));
        return this;
    }

    public void increment(List<Long> values) {
        Assert.assertTrue((String)("Metric with name '" + this.name + "'  was expected to be registered as incremental with values " + values + " , but actually was registered with values " + this.container.getValuesForValue(MetricsType.INCR_VALUE, this.name)), (boolean)this.container.hasValueWithTypeAndNameAndValues(MetricsType.INCR_VALUE, this.name, values));
    }

    public MockMetricsVerifier gauge() {
        Assert.assertTrue((String)("Metric with name '" + this.name + "' was expected to be registered as gauge, but wasnt"), (boolean)this.container.hasValueWithTypeAndName(MetricsType.GAUGE, this.name));
        return this;
    }

    public MockMetricsVerifier gauge(int times) {
        Assert.assertTrue((String)("Metric with name '" + this.name + "' was expected to be registered as gauge " + times + " times, but actually was registered " + this.container.getCountForValue(MetricsType.GAUGE, this.name) + " times"), (boolean)this.container.hasValueWithTypeAndNameAndCount(MetricsType.GAUGE, this.name, times));
        return this;
    }

    public void gauge(List<Long> values) {
        Assert.assertTrue((String)("Metric with name '" + this.name + "' was expected to be registered as gauge with values " + values + " , but actually was registered with values " + this.container.getValuesForValue(MetricsType.GAUGE, this.name)), (boolean)this.container.hasValueWithTypeAndNameAndValues(MetricsType.GAUGE, this.name, values));
    }

    public MockMetricsVerifier event() {
        Assert.assertTrue((String)("Metric with name '" + this.name + "'  was expected to be registered as timer or chronable event value, but wasnt"), (boolean)this.container.hasValueWithTypeAndName(MetricsType.TIME, this.name));
        return this;
    }

    public MockMetricsVerifier event(int times) {
        Assert.assertTrue((String)("Metric with name '" + this.name + "' was expected to be registered as timer or chronable event value " + times + " times, but actually was registered " + this.container.getCountForValue(MetricsType.TIME, this.name) + " times"), (boolean)this.container.hasValueWithTypeAndNameAndCount(MetricsType.TIME, this.name, times));
        return this;
    }

    public void event(List<Long> values) {
        Assert.assertTrue((String)("Metric with name '" + this.name + "' was expected to be registered as timer or chronable event value with values " + values + " , but actually was registered with values " + this.container.getValuesForValue(MetricsType.TIME, this.name)), (boolean)this.container.hasValueWithTypeAndNameAndValues(MetricsType.TIME, this.name, values));
    }
}

