/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.metrics.mock;

import org.ametiste.metrics.MetricsService;
import org.ametiste.metrics.mock.MockMetricsVerifier;
import org.ametiste.metrics.mock.store.MetricsType;
import org.ametiste.metrics.mock.store.MockMetricsContainer;

public class MockMetricsService
implements MetricsService {
    private boolean verifyChainStarted = false;
    private MockMetricsContainer container = new MockMetricsContainer();

    public void gauge(String metricId, int gaugeValue) {
        this.checkIfAlreadyVerified();
        this.container.addValue(MetricsType.GAUGE, metricId, gaugeValue);
    }

    private void checkIfAlreadyVerified() {
        if (this.verifyChainStarted) {
            throw new IllegalArgumentException("After verify chain is started, service cant be used as usual anymore, maybe you need 'resetData()' method call to reset service work");
        }
    }

    public void increment(String targetName, int incrementValue) {
        this.checkIfAlreadyVerified();
        this.container.addValue(MetricsType.INCR_VALUE, targetName, incrementValue);
    }

    public void createEvent(String metricId, int eventValue) {
        this.checkIfAlreadyVerified();
        this.container.addValue(MetricsType.TIME, metricId, eventValue);
    }

    public MockMetricsVerifier verify(String name) {
        this.verifyChainStarted = true;
        return new MockMetricsVerifier(name, this.container);
    }

    public void resetData() {
        this.verifyChainStarted = false;
        this.container.clear();
    }
}

