/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.metrics.mock.store;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametiste.metrics.mock.store.MetricsCount;
import org.ametiste.metrics.mock.store.MetricsType;

public class MockMetricsContainer {
    private Map<String, MetricsCount> singleIncMap = new HashMap<String, MetricsCount>();
    private Map<String, MetricsCount> rangeIncMap = new HashMap<String, MetricsCount>();
    private Map<String, MetricsCount> timeMap = new HashMap<String, MetricsCount>();
    private Map<MetricsType, Map<String, MetricsCount>> container = new HashMap<MetricsType, Map<String, MetricsCount>>();

    public MockMetricsContainer() {
        this.container.put(MetricsType.INCR, this.singleIncMap);
        this.container.put(MetricsType.INCR_VALUE, this.rangeIncMap);
        this.container.put(MetricsType.TIME, this.timeMap);
    }

    public void addValue(MetricsType type, String metricName, long value) {
        this.insertData(this.container.get((Object)type), metricName, value);
    }

    private void insertData(Map<String, MetricsCount> map, String targetName, long value) {
        if (map.containsKey(targetName)) {
            map.get(targetName).addValue(value);
        } else {
            MetricsCount c = new MetricsCount();
            c.addValue(value);
            map.put(targetName, c);
        }
    }

    public boolean hasValueWithName(String name) {
        return this.singleIncMap.containsKey(name) || this.rangeIncMap.containsKey(name) || this.timeMap.containsKey(name);
    }

    public boolean hasValueWithTypeAndName(MetricsType type, String name) {
        return this.container.get((Object)type).containsKey(name);
    }

    public boolean hasValueWithTypeAndNameAndCount(MetricsType type, String name, int times) {
        return this.container.get((Object)type).containsKey(name) && this.container.get((Object)type).get(name).getCount() == times;
    }

    public boolean hasValueWithTypeAndNameAndValues(MetricsType type, String name, List<Long> values) {
        return this.container.get((Object)type).containsKey(name) && values.equals(this.container.get((Object)type).get(name).getValues());
    }

    public int getCountForValue(MetricsType type, String name) {
        if (!this.container.get((Object)type).containsKey(name)) {
            throw new IllegalArgumentException("No metric with this name is registered for this type");
        }
        return this.container.get((Object)type).get(name).getCount();
    }

    public List<Long> getValuesForValue(MetricsType type, String name) {
        if (!this.container.get((Object)type).containsKey(name)) {
            throw new IllegalArgumentException("No metric with this name is registered for this type");
        }
        return this.container.get((Object)type).get(name).getValues();
    }

    public void clear() {
        this.singleIncMap.clear();
        this.rangeIncMap.clear();
        this.timeMap.clear();
    }
}

