/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.metrics.mock.aggregator;

import org.ametiste.metrics.MetricsAggregator;
import org.ametiste.metrics.mock.MockMetricsVerifier;
import org.ametiste.metrics.mock.store.MetricsType;
import org.ametiste.metrics.mock.store.MockMetricsContainer;

public class MockMetricsAggregator
implements MetricsAggregator {
    boolean verifyChainStarted = false;
    private MockMetricsContainer container = new MockMetricsContainer();

    private void checkIfAlreadyVerified() {
        if (this.verifyChainStarted) {
            throw new IllegalArgumentException("After verify chain is started, service cant be used as usual anymore, maybe you need 'resetData()' method call to reset service work");
        }
    }

    public void increment(String metricId) {
        this.checkIfAlreadyVerified();
        this.container.addValue(MetricsType.INCR, metricId, 1L);
    }

    public void event(String metricId, int value) {
        this.checkIfAlreadyVerified();
        this.container.addValue(MetricsType.TIME, metricId, value);
    }

    public void increment(String metricId, int inc) {
        this.checkIfAlreadyVerified();
        this.container.addValue(MetricsType.INCR_VALUE, metricId, inc);
    }

    public MockMetricsVerifier verify(String name) {
        this.verifyChainStarted = true;
        return new MockMetricsVerifier(name, this.container);
    }

    public void resetData() {
        this.verifyChainStarted = false;
        this.container.clear();
    }
}

