/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.metrics.mock;

import org.ametiste.metrics.MetricsService;
import org.ametiste.metrics.mock.MockMetricsVerifier;
import org.ametiste.metrics.mock.store.MetricsType;
import org.ametiste.metrics.mock.store.MockMetricsContainer;

public class MockMetricsService
implements MetricsService {
    boolean verifyChainStarted = false;
    private MockMetricsContainer container = new MockMetricsContainer();

    public void increment(String targetName) {
        this.checkIfAlreadyVerified();
        this.container.addValue(MetricsType.INCR, targetName, 1L);
    }

    private void checkIfAlreadyVerified() {
        if (this.verifyChainStarted) {
            throw new IllegalArgumentException("After verify chain is started, service cant be used as usual anymore, maybe you need 'resetData()' method call to reset service work");
        }
    }

    public void increment(String targetName, int incrementValue) {
        this.checkIfAlreadyVerified();
        this.container.addValue(MetricsType.INCR_VALUE, targetName, incrementValue);
    }

    public void createEvent(String name, long startTime, long endTime) {
        this.checkIfAlreadyVerified();
        long incrementValue = endTime - startTime;
        this.container.addValue(MetricsType.TIME, name, incrementValue);
    }

    public void createEvent(String metricId, int eventValue) {
        this.checkIfAlreadyVerified();
        this.container.addValue(MetricsType.TIME, metricId, eventValue);
    }

    public MockMetricsVerifier verify(String name) {
        this.verifyChainStarted = true;
        return new MockMetricsVerifier(name, this.container);
    }

    public void resetData() {
        this.verifyChainStarted = false;
        this.container.clear();
    }
}

