/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.metrics.boot.configuration;

import org.ametiste.metrics.MetricsAggregator;
import org.ametiste.metrics.boot.configuration.CoreAggregator;
import org.ametiste.metrics.boot.configuration.MetricsProperties;
import org.ametiste.metrics.jmx.JmxMetricAggregator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={MetricsProperties.class})
@ConditionalOnProperty(prefix="org.ametiste.metrics.jmx", name={"enabled"}, matchIfMissing=true)
public class JmxConfiguration {
    @Autowired
    private MetricsProperties properties;

    @Bean
    @CoreAggregator
    public MetricsAggregator jmxAggregator() {
        return new JmxMetricAggregator(this.properties.getJmx().getDomain());
    }
}

