/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.lpp.protocol.lmdb.model;

import org.ametiste.lib.lmdb.entry.LmdbEntry;
import org.ametiste.lpp.protocol.lmdb.entry.DatabaseEntry;

public class DefaultDatabaseEntry
implements DatabaseEntry {
    private final String key;
    private final byte[] value;

    public DefaultDatabaseEntry(LmdbEntry entry) {
        DefaultDatabaseEntry.notNull(entry, "'entry' must be initialized");
        this.key = entry.key();
        this.value = (byte[])entry.value().clone();
    }

    public DefaultDatabaseEntry(String key, byte[] value) {
        DefaultDatabaseEntry.notNull(key, "'key' must be initialized");
        DefaultDatabaseEntry.notNull(value, "'value' must be initialized");
        this.key = key;
        this.value = (byte[])value.clone();
    }

    public String key() {
        return this.key;
    }

    public byte[] value() {
        return this.value;
    }

    private static void notNull(Object o, String msg) {
        if (o == null) {
            throw new IllegalArgumentException(msg);
        }
    }
}

