/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.lpp.protocol.lmdb;

import java.nio.file.Path;
import java.util.function.Supplier;
import org.ametiste.lib.lmdb.LmdbConnector;
import org.ametiste.lpp.protocol.lmdb.LmdbException;
import org.ametiste.lpp.protocol.lmdb.LmdbProtocol;
import org.ametiste.lpp.protocol.lmdb.iterator.DatabaseIterator;
import org.ametiste.lpp.protocol.lmdb.iterator.LmdbIteratorAdapter;
import org.ametiste.routine.dsl.annotations.LambdaProtocol;
import org.springframework.beans.factory.annotation.Autowired;

@LambdaProtocol
public class AmetisteLmdbProtocol
implements LmdbProtocol {
    @Autowired
    private LmdbConnector connector;

    public DatabaseIterator iterate(Path path) throws LmdbException {
        return AmetisteLmdbProtocol.checkedCreation(() -> new LmdbIteratorAdapter(this.connector.iterate(path)));
    }

    public DatabaseIterator seek(Path path, String key) throws LmdbException {
        return AmetisteLmdbProtocol.checkedCreation(() -> new LmdbIteratorAdapter(this.connector.seek(path, key)));
    }

    private static <T> T checkedCreation(Supplier<T> supplier) throws LmdbException {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            throw new LmdbException(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

