/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.lib.lmdb.iterator;

import org.ametiste.lib.lmdb.entry.DefaultLmdbEntry;
import org.ametiste.lib.lmdb.iterator.LmdbIterator;
import org.fusesource.lmdbjni.Database;
import org.fusesource.lmdbjni.Entry;
import org.fusesource.lmdbjni.EntryIterator;
import org.fusesource.lmdbjni.Env;
import org.fusesource.lmdbjni.Transaction;

public class ReadOnlyLmdbIterator
implements LmdbIterator {
    private final Env env;
    private final Database db;
    private final EntryIterator iter;

    public ReadOnlyLmdbIterator(String path, String key) {
        if (path == null) {
            throw new IllegalArgumentException("'env' must be initialized");
        }
        this.env = new Env(path);
        Transaction tx = this.env.createReadTransaction();
        this.db = this.env.openDatabase();
        this.iter = key == null ? this.db.iterate(tx) : this.db.seek(tx, key.getBytes());
    }

    public void close() throws Exception {
        this.iter.close();
        this.db.close();
        this.env.close();
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public DefaultLmdbEntry next() {
        Entry entry = this.iter.next();
        return new DefaultLmdbEntry(new String(entry.getKey()), entry.getValue());
    }
}

