/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.lib.lmdb.entry;

import org.ametiste.lib.lmdb.entry.LmdbEntry;
import org.fusesource.lmdbjni.Entry;

public class DefaultLmdbEntry
implements LmdbEntry {
    private final String key;
    private final byte[] value;

    public DefaultLmdbEntry(Entry entry) {
        DefaultLmdbEntry.notNull(entry, "'entry' must be initialized");
        this.key = new String(entry.getKey());
        this.value = (byte[])entry.getValue().clone();
    }

    public DefaultLmdbEntry(String key, byte[] value) {
        DefaultLmdbEntry.notNull(key, "'key' must be initialized");
        DefaultLmdbEntry.notNull(value, "'value' must be initialized");
        this.key = key;
        this.value = (byte[])value.clone();
    }

    public String key() {
        return this.key;
    }

    public byte[] value() {
        return this.value;
    }

    private static void notNull(Object o, String msg) {
        if (o == null) {
            throw new IllegalArgumentException(msg);
        }
    }
}

