/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.lib.lmdb;

import java.nio.file.Path;
import java.util.function.Supplier;
import org.ametiste.lib.lmdb.LmdbConnector;
import org.ametiste.lib.lmdb.LmdbConnectorException;
import org.ametiste.lib.lmdb.iterator.LmdbIterator;
import org.ametiste.lib.lmdb.iterator.ReadOnlyLmdbIterator;

public class JniLmdbConnector
implements LmdbConnector {
    public LmdbIterator iterate(Path path) throws LmdbConnectorException {
        return JniLmdbConnector.checkedCreation(() -> new ReadOnlyLmdbIterator(path.toString(), null));
    }

    public LmdbIterator seek(Path path, String key) throws LmdbConnectorException {
        return JniLmdbConnector.checkedCreation(() -> new ReadOnlyLmdbIterator(path.toString(), key));
    }

    private static <T> T checkedCreation(Supplier<T> supplier) throws LmdbConnectorException {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            throw new LmdbConnectorException(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

