/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.laplatform.protocol.gateway;

import java.util.Map;
import org.ametiste.laplatform.protocol.Protocol;
import org.ametiste.laplatform.protocol.ProtocolFactory;
import org.ametiste.laplatform.protocol.ProtocolGateway;
import org.ametiste.laplatform.protocol.gateway.DirectGatewayContext;
import org.ametiste.laplatform.protocol.gateway.DirectProtocolGateway;

public class ProtocolGatewayService {
    private final Map<Class<? extends Protocol>, ProtocolFactory<?>> protocolFactories;

    public ProtocolGatewayService(Map<Class<? extends Protocol>, ProtocolFactory<?>> protocolFactories) {
        this.protocolFactories = protocolFactories;
    }

    public void registerGatewayFactory(Entry entry) {
        this.protocolFactories.put(entry.protocolType, entry.protocolFactory);
    }

    public void registerGatewayFactory(Class<? extends Protocol> protocolType, ProtocolFactory<? extends Protocol> protocolFactory) {
        this.registerGatewayFactory(new Entry(protocolType, protocolFactory));
    }

    public ProtocolGateway createGateway(String clientId, Map<String, String> gatewayProperties) {
        return new DirectProtocolGateway(this.protocolFactories, new DirectGatewayContext(clientId, gatewayProperties));
    }

    public static final class Entry {
        final Class<? extends Protocol> protocolType;
        final ProtocolFactory<? extends Protocol> protocolFactory;

        public Entry(Class<? extends Protocol> protocolType, ProtocolFactory<? extends Protocol> protocolFactory) {
            this.protocolType = protocolType;
            this.protocolFactory = protocolFactory;
        }
    }
}

