/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.laplatform.protocol.gateway;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametiste.laplatform.protocol.GatewayContext;
import org.ametiste.laplatform.protocol.Protocol;
import org.ametiste.laplatform.protocol.ProtocolFactory;
import org.ametiste.laplatform.protocol.ProtocolGateway;
import org.ametiste.laplatform.protocol.gateway.OptionDescriptor;
import org.ametiste.laplatform.protocol.gateway.SessionOption;
import org.ametiste.laplatform.protocol.gateway.SessionStatProxy;
import org.ametiste.laplatform.protocol.gateway.SimpleOptionDescriptor;

public class DirectProtocolGateway
implements ProtocolGateway {
    private final Map<Class<? extends Protocol>, ProtocolFactory<?>> protocols;
    private final Map<Class<? extends Protocol>, SessionStatProxy> sessionProxies;
    private final GatewayContext gc;

    public DirectProtocolGateway(Map<Class<? extends Protocol>, ProtocolFactory<?>> protocols, GatewayContext gc) {
        this.gc = gc;
        this.protocols = protocols;
        this.sessionProxies = new HashMap<Class<? extends Protocol>, SessionStatProxy>();
    }

    @Override
    public <T extends Protocol> T session(Class<T> protocolType, List<SessionOption> options) {
        if (!this.protocols.containsKey(protocolType)) {
            throw new RuntimeException("Gateway has no access to the requested protocol: " + protocolType.getName());
        }
        Object protocol = this.protocols.get(protocolType).createProtocol(this.gc);
        if (!protocolType.isAssignableFrom(protocol.getClass())) {
            throw new IllegalStateException("Gateway has no access to protocol of the given type: " + protocolType.getName());
        }
        Object sessionedProtocol = protocol;
        if (options.contains((Object)SessionOption.STATS)) {
            SessionStatProxy sessionProxy = new SessionStatProxy(sessionedProtocol);
            sessionedProtocol = this.newProtocolSession((Protocol)sessionedProtocol, sessionProxy, (Class<? extends Protocol>)protocolType);
            this.sessionProxies.put(protocolType, sessionProxy);
        }
        try {
            return (T)((Protocol)protocolType.cast(sessionedProtocol));
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Gateway has error during access to protocol of the given type: " + protocolType.getName(), e);
        }
    }

    @Override
    public OptionDescriptor sessionOption(Class<?> protocolType, SessionOption option) {
        if (option.equals((Object)SessionOption.STATS)) {
            if (!this.sessionProxies.containsKey(protocolType)) {
                throw new RuntimeException("Gateway has no access to the session stats, try enable stats tracking for this session: " + protocolType.getName());
            }
            SessionStatProxy sessionStatProxy = this.sessionProxies.get(protocolType);
            return new SimpleOptionDescriptor(Collections.singletonMap("session.last.invocation.time", sessionStatProxy.lastInvocationTimeTaken()));
        }
        throw new IllegalArgumentException("Unsupported session option: " + (Object)((Object)option));
    }

    public Protocol newProtocolSession(Protocol obj, SessionStatProxy sessionStatProxy, Class<? extends Protocol> protocolType) {
        return protocolType.cast(Proxy.newProxyInstance(obj.getClass().getClassLoader(), obj.getClass().getInterfaces(), (InvocationHandler)sessionStatProxy));
    }
}

