/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.laplatform.protocol.gateway;

import java.util.Map;
import org.ametiste.laplatform.protocol.GatewayContext;
import org.ametiste.laplatform.protocol.Protocol;
import org.ametiste.laplatform.protocol.ProtocolFactory;
import org.ametiste.laplatform.protocol.ProtocolGateway;

public class DirectProtocolGateway
implements ProtocolGateway {
    private final Map<Class<? extends Protocol>, ProtocolFactory<?>> protocols;
    private final GatewayContext gc;

    public DirectProtocolGateway(Map<Class<? extends Protocol>, ProtocolFactory<?>> protocols, GatewayContext gc) {
        this.gc = gc;
        this.protocols = protocols;
    }

    @Override
    public <T extends Protocol> T session(Class<T> protocolType) {
        if (!this.protocols.containsKey(protocolType)) {
            throw new RuntimeException("Gateway has no access to the requested protocol: " + protocolType.getName());
        }
        Object protocol = this.protocols.get(protocolType).createProtocol(this.gc);
        if (!protocolType.isAssignableFrom(protocol.getClass())) {
            throw new IllegalStateException("Gateway has no access to protocol of the given type: " + protocolType.getName());
        }
        try {
            return (T)((Protocol)protocolType.cast(protocol));
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Gateway has error during access to protocol of the given type: " + protocolType.getName(), e);
        }
    }
}

