/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.laplatform.protocol.configuration;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.jodah.typetools.TypeResolver;
import org.ametiste.laplatform.protocol.Protocol;
import org.ametiste.laplatform.protocol.ProtocolFactory;

public class ProtocolUtils {
    public static <T extends Protocol> Pair<T, ProtocolFactory<T>> protocolFactoryPair(ProtocolFactory<T> pf) {
        return new Pair(ProtocolUtils.lookupProtocolInterface(pf), pf, null);
    }

    public static Map<Class<? extends Protocol>, ProtocolFactory<?>> protocolsMapping(List<ProtocolFactory<?>> protocolFactories) {
        return protocolFactories.stream().collect(Collectors.toMap(p -> p.protocolType(), p -> p));
    }

    private static <T extends Protocol> Class<T> lookupProtocolInterface(ProtocolFactory<T> pf) {
        return TypeResolver.resolveRawArgument(ProtocolFactory.class, pf.getClass());
    }

    public static class Pair<P extends Protocol, F extends ProtocolFactory<P>> {
        public final Class<P> protocol;
        public final F factory;

        private Pair(Class<P> protocol, F factory) {
            this.protocol = protocol;
            this.factory = factory;
        }

        /* synthetic */ Pair(Class x0, ProtocolFactory x1, 1 x2) {
            this(x0, x1);
        }
    }
}

