/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.laplatform.protocol.configuration;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametiste.laplatform.protocol.gateway.ProtocolGatewayService;
import org.ametiste.laplatform.protocol.gateway.ProtocolGatewayTool;
import org.ametiste.laplatform.sdk.protocol.Protocol;
import org.ametiste.laplatform.sdk.protocol.ProtocolFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ProtocolGatewayServiceConfiguration {
    @Autowired(required=false)
    private List<ProtocolFactory<?>> protocolFactories = Collections.emptyList();
    @Autowired(required=false)
    private List<ProtocolGatewayTool> protocolGatewayTools = Collections.emptyList();

    @Bean
    public ProtocolGatewayService protocolGatewayService() {
        return new ProtocolGatewayService(this.protocolGatewayTools, ProtocolGatewayServiceConfiguration.protocolsMapping(this.protocolFactories));
    }

    private static Map<Class<? extends Protocol>, ProtocolFactory<?>> protocolsMapping(List<ProtocolFactory<?>> protocolFactories) {
        return protocolFactories.stream().collect(Collectors.toMap(ProtocolFactory::protocolType, p -> p));
    }
}

