/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.jdbc.nuodb;

import com.google.common.collect.ImmutableList;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.alfasoftware.morf.jdbc.AbstractSqlDialectTest;
import org.alfasoftware.morf.jdbc.NamedParameterPreparedStatement;
import org.alfasoftware.morf.jdbc.SqlDialect;
import org.alfasoftware.morf.jdbc.SqlScriptExecutor;
import org.alfasoftware.morf.jdbc.nuodb.NuoDBDialect;
import org.alfasoftware.morf.metadata.Column;
import org.alfasoftware.morf.metadata.DataType;
import org.alfasoftware.morf.metadata.SchemaUtils;
import org.alfasoftware.morf.sql.SqlUtils;
import org.alfasoftware.morf.sql.element.SqlParameter;
import org.junit.Assert;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestNuoDBDialect
extends AbstractSqlDialectTest {
    protected SqlDialect createTestDialect() {
        return new NuoDBDialect("SCM");
    }

    protected String tableName(String baseName) {
        return "SCM." + baseName;
    }

    protected List<String> expectedCreateTableStatements() {
        return Arrays.asList("CREATE TABLE SCM.Test (id BIGINT NOT NULL, version INTEGER DEFAULT 0, stringField VARCHAR(3), intField INTEGER, floatField DECIMAL(13,2) NOT NULL, dateField DATE, booleanField SMALLINT, charField VARCHAR(1), blobField BLOB, bigIntegerField BIGINT DEFAULT 12345, clobField CLOB, PRIMARY KEY (id))", "DROP INDEX IF EXISTS SCM.Test_NK", "CREATE UNIQUE INDEX Test_NK ON SCM.Test (stringField)", "DROP INDEX IF EXISTS SCM.Test_1", "CREATE UNIQUE INDEX Test_1 ON SCM.Test (intField,floatField)", "CREATE TABLE SCM.Alternate (id BIGINT NOT NULL, version INTEGER DEFAULT 0, stringField VARCHAR(3), PRIMARY KEY (id))", "DROP INDEX IF EXISTS SCM.Alternate_1", "CREATE INDEX Alternate_1 ON SCM.Alternate (stringField)", "CREATE TABLE SCM.NonNull (id BIGINT NOT NULL, version INTEGER DEFAULT 0, stringField VARCHAR(3) NOT NULL, intField DECIMAL(8,0) NOT NULL, booleanField SMALLINT NOT NULL, dateField DATE NOT NULL, blobField BLOB NOT NULL, PRIMARY KEY (id))", "CREATE TABLE SCM.CompositePrimaryKey (id BIGINT NOT NULL, version INTEGER DEFAULT 0, stringField VARCHAR(3) NOT NULL, secondPrimaryKey VARCHAR(3) NOT NULL, PRIMARY KEY (id, secondPrimaryKey))", "DROP SEQUENCE IF EXISTS SCM.AutoNumber_IDS_5", "CREATE SEQUENCE SCM.AutoNumber_IDS_5 START WITH 5", "CREATE TABLE SCM.AutoNumber (intField BIGINT GENERATED BY DEFAULT AS IDENTITY(AutoNumber_IDS_5), PRIMARY KEY (intField))");
    }

    protected List<String> expectedCreateTemporaryTableStatements() {
        return Arrays.asList("CREATE TEMPORARY TABLE TEMP_TempTest (id BIGINT NOT NULL, version INTEGER DEFAULT 0, stringField VARCHAR(3), intField INTEGER, floatField DECIMAL(13,2) NOT NULL, dateField DATE, booleanField SMALLINT, charField VARCHAR(1), blobField BLOB, bigIntegerField BIGINT DEFAULT 12345, clobField CLOB, PRIMARY KEY (id))", "DROP INDEX IF EXISTS TempTest_NK", "CREATE UNIQUE INDEX TempTest_NK ON TEMP_TempTest (stringField)", "DROP INDEX IF EXISTS TempTest_1", "CREATE INDEX TempTest_1 ON TEMP_TempTest (intField,floatField)", "CREATE TEMPORARY TABLE TEMP_TempAlternate (id BIGINT NOT NULL, version INTEGER DEFAULT 0, stringField VARCHAR(3), PRIMARY KEY (id))", "DROP INDEX IF EXISTS TempAlternate_1", "CREATE INDEX TempAlternate_1 ON TEMP_TempAlternate (stringField)", "CREATE TEMPORARY TABLE TEMP_TempNonNull (id BIGINT NOT NULL, version INTEGER DEFAULT 0, stringField VARCHAR(3) NOT NULL, intField DECIMAL(8,0) NOT NULL, booleanField SMALLINT NOT NULL, dateField DATE NOT NULL, blobField BLOB NOT NULL, PRIMARY KEY (id))");
    }

    protected List<String> expectedCreateTableStatementsWithLongTableName() {
        return Arrays.asList("CREATE TABLE SCM.tableWithANameThatExceedsTwentySevenCharactersToMakeSureSchemaNameDoesNotGetFactoredIntoOracleNameTruncation (id BIGINT NOT NULL, version INTEGER DEFAULT 0, stringField VARCHAR(3), intField DECIMAL(8,0), floatField DECIMAL(13,2) NOT NULL, dateField DATE, booleanField SMALLINT, charField VARCHAR(1), PRIMARY KEY (id))", "DROP INDEX IF EXISTS SCM.Test_NK", "CREATE UNIQUE INDEX Test_NK ON SCM.tableWithANameThatExceedsTwentySevenCharactersToMakeSureSchemaNameDoesNotGetFactoredIntoOracleNameTruncation (stringField)", "DROP INDEX IF EXISTS SCM.Test_1", "CREATE INDEX Test_1 ON SCM.tableWithANameThatExceedsTwentySevenCharactersToMakeSureSchemaNameDoesNotGetFactoredIntoOracleNameTruncation (intField,floatField)");
    }

    protected List<String> expectedDropTableStatements() {
        return Arrays.asList("drop table SCM.Test", "DROP INDEX IF EXISTS SCM.Test_NK", "DROP INDEX IF EXISTS SCM.Test_1");
    }

    protected List<String> expectedDropTempTableStatements() {
        return Arrays.asList("drop table TEMP_TempTest", "DROP INDEX IF EXISTS TempTest_NK", "DROP INDEX IF EXISTS TempTest_1");
    }

    protected List<String> expectedTruncateTableStatements() {
        return Arrays.asList("TRUNCATE TABLE SCM.Test");
    }

    protected List<String> expectedTruncateTempTableStatements() {
        return Arrays.asList("TRUNCATE TABLE TEMP_TempTest");
    }

    protected List<String> expectedDeleteAllFromTableStatements() {
        return Arrays.asList("DELETE FROM SCM.Test");
    }

    protected String expectedParameterisedInsertStatement() {
        return "INSERT INTO SCM.Test (id, version, stringField, intField, floatField, dateField, booleanField, charField, blobField, bigIntegerField, clobField) VALUES (5, :version, 'Escap''d', 7, :floatField, 20100405, 1, :charField, :blobField, :bigIntegerField, :clobField)";
    }

    protected String expectedParameterisedInsertStatementWithTableInDifferentSchema() {
        return "INSERT INTO MYSCHEMA.Test (id, version, stringField, intField, floatField, dateField, booleanField, charField, blobField, bigIntegerField, clobField) VALUES (5, :version, 'Escap''d', 7, :floatField, 20100405, 1, :charField, :blobField, :bigIntegerField, :clobField)";
    }

    protected List<String> expectedAutoGenerateIdStatement() {
        return ImmutableList.of((Object)"DELETE FROM idvalues where name = 'Test'", (Object)"INSERT INTO idvalues (name, value) VALUES('Test', (SELECT COALESCE(MAX(id) + 1, 1) AS CurrentValue FROM SCM.Test))", (Object)"INSERT INTO SCM.Test (version, stringField, id) SELECT version, stringField, (SELECT COALESCE(value, 0) FROM SCM.idvalues WHERE (name = 'Test')) + Other.id FROM SCM.Other");
    }

    protected List<String> expectedInsertWithIdAndVersion() {
        return Arrays.asList("DELETE FROM idvalues where name = 'Test'", "INSERT INTO idvalues (name, value) VALUES('Test', (SELECT COALESCE(MAX(id) + 1, 1) AS CurrentValue FROM SCM.Test))", "INSERT INTO SCM.Test (stringField, id, version) SELECT stringField, (SELECT COALESCE(value, 0) FROM SCM.idvalues WHERE (name = 'Test')) + Other.id, 0 AS version FROM SCM.Other");
    }

    protected void verifyPostInsertStatementsInsertingUnderAutonumLimit(SqlScriptExecutor sqlScriptExecutor, Connection connection) {
    }

    protected void verifyRepairAutoNumberStartPosition(SqlScriptExecutor sqlScriptExecutor, Connection connection) {
    }

    protected void verifyPostInsertStatementsNotInsertingUnderAutonumLimit(SqlScriptExecutor sqlScriptExecutor, Connection connection) {
    }

    protected String expectedSelectMinimumWithExpression() {
        return "SELECT MIN(intField - 1) FROM " + this.tableName("Test");
    }

    protected String expectedSqlForMathOperations1() {
        return "a / b + c";
    }

    protected String expectedSqlForMathOperations2() {
        return "a / b + 100";
    }

    protected String expectedSqlForMathOperations3() {
        return "a / (b + c)";
    }

    protected String expectedSqlForMathOperations4() {
        return "a / (b + 100)";
    }

    protected String expectedSqlForMathOperations5() {
        return "a * (b + c)";
    }

    protected String expectedSqlForMathOperations6() {
        return "a + b / (c - d)";
    }

    protected String expectedSqlForMathOperations7() {
        return "(a + b) / (c - d)";
    }

    protected String expectedSqlForMathOperations8() {
        return "a + b + c + d + e";
    }

    protected String expectedSqlForMathOperations9() {
        return "a + b + (c / d) + e + 100 + f / 5";
    }

    protected String expectedSqlForMathOperations10() {
        return "(a + b + (c / d) + e + 100 + f) / 5";
    }

    protected String expectedSqlForMathOperations11() {
        return "(a / 100 + 1) / b + 100";
    }

    protected String expectedSqlForMathOperations12() {
        return "(a + b) / c";
    }

    protected String expectedSqlForMathOperations13() {
        return "a + b + c / 2";
    }

    protected String expectedSqlForMathOperations14() {
        return "a + (b + c) / 2";
    }

    protected String expectedSqlForMathOperations15() {
        return "a + (b + c) / 2";
    }

    protected String expectedSqlForMathOperationsForExistingDataFix1() {
        return "ROUND(doublevalue / 1000 * doublevalue, 2)";
    }

    protected String expectedSqlForMathOperationsForExistingDataFix2(String sqlForRandom) {
        return "FLOOR(" + sqlForRandom + " * " + this.expectedDecimalRepresentationOfLiteral("999999.0") + ")";
    }

    protected String expectedSqlForMathOperationsForExistingDataFix3() {
        return "MAX(assetLocationDate * 100000 + assetLocationTime)";
    }

    protected String expectedSqlForMathOperationsForExistingDataFix4() {
        return "invoiceLineReceived * vatRate / (vatRate + 100)";
    }

    protected String expectedSelectSumWithExpression() {
        return "SELECT SUM(intField * 2 / 3) FROM " + this.tableName("Test");
    }

    protected List<String> expectedSqlInsertIntoValuesWithComplexField() {
        return Arrays.asList("INSERT INTO " + this.tableName("TableOne") + " (id, value) VALUES (3, 1 + 2)");
    }

    protected String expectedSelectMaximumWithExpression() {
        return "SELECT MAX(intField + 1) FROM " + this.tableName("Test");
    }

    protected List<String> expectedSpecifiedValueInsert() {
        return Arrays.asList("DELETE FROM idvalues where name = 'Test'", "INSERT INTO idvalues (name, value) VALUES('Test', (SELECT COALESCE(MAX(id) + 1, 1) AS CurrentValue FROM SCM.Test))", "INSERT INTO SCM.Test (stringField, intField, floatField, dateField, booleanField, charField, id, version, blobField, bigIntegerField, clobField) VALUES ('Escap''d', 7, 11.25, 20100405, 1, 'X', (SELECT COALESCE(value, 1) FROM SCM.idvalues WHERE (name = 'Test')), 0, null, 12345, null)");
    }

    protected List<String> expectedSpecifiedValueInsertWithTableInDifferentSchema() {
        return Arrays.asList("DELETE FROM idvalues where name = 'Test'", "INSERT INTO idvalues (name, value) VALUES('Test', (SELECT COALESCE(MAX(id) + 1, 1) AS CurrentValue FROM MYSCHEMA.Test))", "INSERT INTO MYSCHEMA.Test (stringField, intField, floatField, dateField, booleanField, charField, id, version, blobField, bigIntegerField, clobField) VALUES ('Escap''d', 7, 11.25, 20100405, 1, 'X', (SELECT COALESCE(value, 1) FROM SCM.idvalues WHERE (name = 'Test')), 0, null, 12345, null)");
    }

    protected String expectedParameterisedInsertStatementWithNoColumnValues() {
        return "INSERT INTO SCM.Test (id, version, stringField, intField, floatField, dateField, booleanField, charField, blobField, bigIntegerField, clobField) VALUES (:id, :version, :stringField, :intField, :floatField, :dateField, :booleanField, :charField, :blobField, :bigIntegerField, :clobField)";
    }

    protected String expectedEmptyStringInsertStatement() {
        return "INSERT INTO SCM.Test (stringField, id, version, intField, floatField, dateField, booleanField, charField, blobField, bigIntegerField, clobField) VALUES (NULL, (SELECT COALESCE(value, 1) FROM SCM.idvalues WHERE (name = 'Test')), 0, 0, 0, null, 0, NULL, null, 12345, null)";
    }

    protected String expectedConcatenationWithCase() {
        return "SELECT COALESCE(assetDescriptionLine1,'') || COALESCE(CASE WHEN (taxVariationIndicator = 'Y') THEN exposureCustomerNumber ELSE invoicingCustomerNumber END,'') AS test FROM SCM.schedule";
    }

    protected String expectedConcatenationWithFunction() {
        return "SELECT COALESCE(assetDescriptionLine1,'') || COALESCE(MAX(scheduleStartDate),'') AS test FROM SCM.schedule";
    }

    protected String expectedConcatenationWithMultipleFieldLiterals() {
        return "SELECT COALESCE('ABC','') || COALESCE(' ','') || COALESCE('DEF','') AS assetDescription FROM SCM.schedule";
    }

    protected String expectedNestedConcatenations() {
        return "SELECT COALESCE(field1,'') || COALESCE(COALESCE(field2,'') || COALESCE('XYZ',''),'') AS test FROM SCM.schedule";
    }

    protected String expectedSelectWithConcatenation1() {
        return "SELECT COALESCE(assetDescriptionLine1,'') || COALESCE(' ','') || COALESCE(assetDescriptionLine2,'') AS assetDescription FROM SCM.schedule";
    }

    protected String expectedSelectWithConcatenation2() {
        return "SELECT COALESCE(assetDescriptionLine1,'') || COALESCE('XYZ','') || COALESCE(assetDescriptionLine2,'') AS assetDescription FROM SCM.schedule";
    }

    protected String expectedIsNull() {
        return "COALESCE('A', 'B')";
    }

    protected String expectedMathsPlus() {
        return "1 + 1";
    }

    protected String expectedMathsMinus() {
        return "1 - 1";
    }

    protected String expectedMathsDivide() {
        return "1 / 1";
    }

    protected String expectedMathsMultiply() {
        return "1 * 1";
    }

    protected String expectedStringCast() {
        return "CAST(value AS VARCHAR(10))";
    }

    protected String expectedBigIntCast() {
        return "CAST(value AS BIGINT)";
    }

    protected String expectedBigIntFunctionCast() {
        return "CAST(MIN(value) AS BIGINT)";
    }

    protected String expectedBooleanCast() {
        return "CAST(value AS SMALLINT)";
    }

    protected String expectedDateCast() {
        return "CAST(value AS DATE)";
    }

    protected String expectedDecimalCast() {
        return "CAST(value AS DECIMAL(10,2))";
    }

    protected String expectedIntegerCast() {
        return "CAST(value AS INTEGER)";
    }

    protected String expectedStringLiteralToIntegerCast() {
        return "CAST(" + this.stringLiteralPrefix() + "'1234567890' AS INTEGER)";
    }

    protected String expectedSelectWithUnion() {
        return "SELECT stringField FROM SCM.Other UNION SELECT stringField FROM SCM.Test UNION ALL SELECT stringField FROM SCM.Alternate ORDER BY stringField";
    }

    protected List<String> expectedAlterTableAddIntegerColumnStatement() {
        return Arrays.asList("ALTER TABLE SCM.Test ADD COLUMN intField_new INTEGER NULL");
    }

    protected List<String> expectedAlterTableAlterIntegerColumnStatement() {
        return Arrays.asList("DROP INDEX SCM.Test_1", "ALTER TABLE SCM.Test ALTER COLUMN intField NOT NULL DEFAULT 0", "ALTER TABLE SCM.Test ALTER COLUMN intField DROP DEFAULT", "CREATE UNIQUE INDEX Test_1 ON SCM.Test (intField,floatField)");
    }

    protected String expectedDateLiteral() {
        return "DATE('2010-01-02')";
    }

    protected List<String> expectedAlterTableAddStringColumnStatement() {
        return Arrays.asList("ALTER TABLE SCM.Test ADD COLUMN stringField_new VARCHAR(6) NULL");
    }

    protected List<String> expectedAlterTableAlterStringColumnStatement() {
        return Arrays.asList("DROP INDEX SCM.Test_NK", "ALTER TABLE SCM.Test ALTER COLUMN stringField TYPE VARCHAR(6)", "CREATE UNIQUE INDEX Test_NK ON SCM.Test (stringField)");
    }

    protected List<String> expectedAlterTableAddBooleanColumnStatement() {
        return Arrays.asList("ALTER TABLE SCM.Test ADD COLUMN booleanField_new SMALLINT NULL");
    }

    protected List<String> expectedAlterTableAlterBooleanColumnStatement() {
        return Arrays.asList("ALTER TABLE SCM.Test ALTER COLUMN booleanField NOT NULL DEFAULT 0", "ALTER TABLE SCM.Test ALTER COLUMN booleanField DROP DEFAULT");
    }

    protected List<String> expectedAlterTableAddDateColumnStatement() {
        return Arrays.asList("ALTER TABLE SCM.Test ADD COLUMN dateField_new DATE NULL");
    }

    protected List<String> expectedAlterTableAlterDateColumnStatement() {
        return Arrays.asList("ALTER TABLE SCM.Test ALTER COLUMN dateField NOT NULL DEFAULT 0", "ALTER TABLE SCM.Test ALTER COLUMN dateField DROP DEFAULT");
    }

    protected List<String> expectedAlterTableAddDecimalColumnStatement() {
        return Arrays.asList("ALTER TABLE SCM.Test ADD COLUMN floatField_new DECIMAL(6,3) NULL");
    }

    protected List<String> expectedAlterTableAlterDecimalColumnStatement() {
        return Arrays.asList("DROP INDEX SCM.Test_1", "ALTER TABLE SCM.Test ALTER COLUMN floatField TYPE DECIMAL(14,3)", "ALTER TABLE SCM.Test ALTER COLUMN floatField NULL", "ALTER TABLE SCM.Test ALTER COLUMN floatField DROP DEFAULT", "CREATE UNIQUE INDEX Test_1 ON SCM.Test (intField,floatField)");
    }

    protected List<String> expectedAlterTableAddBigIntegerColumnStatement() {
        return Arrays.asList("ALTER TABLE SCM.Test ADD COLUMN bigIntegerField_new BIGINT NULL");
    }

    protected List<String> expectedAlterTableAlterBigIntegerColumnStatement() {
        return Arrays.asList("ALTER TABLE SCM.Test ALTER COLUMN bigIntegerField DROP DEFAULT", "ALTER TABLE SCM.Test ALTER COLUMN bigIntegerField NULL");
    }

    protected List<String> expectedAlterTableAddBlobColumnStatement() {
        return Arrays.asList("ALTER TABLE SCM.Test ADD COLUMN blobField_new BLOB NULL");
    }

    protected List<String> expectedAlterTableAlterBlobColumnStatement() {
        return Arrays.asList("ALTER TABLE SCM.Test ALTER COLUMN blobField NOT NULL DEFAULT 0", "ALTER TABLE SCM.Test ALTER COLUMN blobField DROP DEFAULT");
    }

    protected List<String> expectedAlterTableAddColumnNotNullableStatement() {
        return Arrays.asList("ALTER TABLE SCM.Test ADD COLUMN dateField_new DATE DEFAULT DATE('2010-01-01') NOT NULL");
    }

    protected List<String> expectedAlterTableAlterColumnFromNullableToNotNullableStatement() {
        return Arrays.asList("ALTER TABLE SCM.Test ALTER COLUMN dateField NOT NULL DEFAULT 0", "ALTER TABLE SCM.Test ALTER COLUMN dateField DROP DEFAULT");
    }

    protected List<String> expectedAlterTableAddColumnWithDefaultStatement() {
        return Arrays.asList("ALTER TABLE SCM.Test ADD COLUMN floatField_new DECIMAL(6,3) DEFAULT 20.33 NULL", "UPDATE Test SET floatField_new = 20.33");
    }

    protected List<String> expectedAlterTableAlterColumnWithDefaultStatement() {
        return Arrays.asList("ALTER TABLE SCM.Test ALTER COLUMN bigIntegerField NOT NULL DEFAULT 54321");
    }

    protected List<String> expectedAlterTableDropColumnWithDefaultStatement() {
        return Arrays.asList("ALTER TABLE SCM.Test DROP COLUMN bigIntegerField", "DROP SEQUENCE IF EXISTS SCM.Test_IDS_0");
    }

    protected List<String> expectedChangeIndexFollowedByChangeOfAssociatedColumnStatement() {
        return Arrays.asList("DROP INDEX SCM.Test_1", "DROP INDEX IF EXISTS SCM.Test_1", "CREATE INDEX Test_1 ON SCM.Test (intField)", "ALTER TABLE SCM.Test ALTER COLUMN intField NOT NULL DEFAULT 0", "ALTER TABLE SCM.Test ALTER COLUMN intField DROP DEFAULT");
    }

    protected List<String> expectedAddIndexStatementsOnSingleColumn() {
        return Arrays.asList("DROP INDEX IF EXISTS SCM.indexName", "CREATE INDEX indexName ON SCM.Test (id)");
    }

    protected String expectedDecimalRepresentationOfLiteral(String literal) {
        int length = literal.length() - 1;
        return String.format("%s", literal, length, length - literal.indexOf("."));
    }

    protected List<String> expectedAddIndexStatementsOnMultipleColumns() {
        return Arrays.asList("DROP INDEX IF EXISTS SCM.indexName", "CREATE INDEX indexName ON SCM.Test (id,version)");
    }

    protected List<String> expectedAddIndexStatementsUnique() {
        return Arrays.asList("DROP INDEX IF EXISTS SCM.indexName", "CREATE UNIQUE INDEX indexName ON SCM.Test (id)");
    }

    protected List<String> expectedAddIndexStatementsUniqueNullable() {
        return Arrays.asList("DROP INDEX IF EXISTS SCM.indexName", "CREATE UNIQUE INDEX indexName ON SCM.Test (stringField,intField,floatField,dateField)");
    }

    protected List<String> expectedAlterTableAlterColumnFromNotNullableToNotNullableStatement() {
        return Arrays.asList("DROP INDEX SCM.Test_1", "ALTER TABLE SCM.Test ALTER COLUMN floatField TYPE DECIMAL(20,3)", "CREATE UNIQUE INDEX Test_1 ON SCM.Test (intField,floatField)");
    }

    protected List<String> expectedAlterTableAlterColumnFromNotNullableToNullableStatement() {
        return Arrays.asList("DROP INDEX SCM.Test_1", "ALTER TABLE SCM.Test ALTER COLUMN floatField TYPE DECIMAL(20,3)", "ALTER TABLE SCM.Test ALTER COLUMN floatField NULL", "ALTER TABLE SCM.Test ALTER COLUMN floatField DROP DEFAULT", "CREATE UNIQUE INDEX Test_1 ON SCM.Test (intField,floatField)");
    }

    protected void verifyBooleanPrepareStatementParameter() throws SQLException {
        SqlParameter booleanColumn = SqlUtils.parameter((Column)SchemaUtils.column((String)"a", (DataType)DataType.BOOLEAN));
        Object nullCheck = null;
        ((NamedParameterPreparedStatement)Mockito.verify((Object)this.callPrepareStatementParameter(booleanColumn, null))).setObject((SqlParameter)ArgumentMatchers.any(SqlParameter.class), ArgumentMatchers.eq(nullCheck));
        NamedParameterPreparedStatement mockStatement = this.callPrepareStatementParameter(booleanColumn, "true");
        ArgumentCaptor intCapture = ArgumentCaptor.forClass(Integer.class);
        ((NamedParameterPreparedStatement)Mockito.verify((Object)mockStatement)).setInt((SqlParameter)ArgumentMatchers.any(SqlParameter.class), ((Integer)intCapture.capture()).intValue());
        Assert.assertEquals((String)"Integer not correctly set on statement", (long)1L, (long)((Integer)intCapture.getValue()).intValue());
        mockStatement = this.callPrepareStatementParameter(booleanColumn, "false");
        intCapture = ArgumentCaptor.forClass(Integer.class);
        ((NamedParameterPreparedStatement)Mockito.verify((Object)mockStatement)).setInt((SqlParameter)ArgumentMatchers.any(SqlParameter.class), ((Integer)intCapture.capture()).intValue());
        Assert.assertEquals((String)"Integer not correctly set on statement", (long)0L, (long)((Integer)intCapture.getValue()).intValue());
    }

    protected List<String> expectedIndexDropStatements() {
        return Arrays.asList("DROP INDEX SCM.indexName");
    }

    protected List<String> expectedAlterColumnMakePrimaryStatements() {
        return Arrays.asList("ALTER TABLE SCM.Test ADD PRIMARY KEY (id, dateField)");
    }

    protected List<String> expectedAlterPrimaryKeyColumnCompositeKeyStatements() {
        return Arrays.asList("DROP INDEX IF EXISTS SCM.\"COMPOSITEPRIMARYKEY..PRIMARY_KEY\"", "ALTER TABLE SCM.CompositePrimaryKey ALTER COLUMN secondPrimaryKey TYPE VARCHAR(5)", "ALTER TABLE SCM.CompositePrimaryKey ADD PRIMARY KEY (id, secondPrimaryKey)");
    }

    protected List<String> expectedAlterRemoveColumnFromCompositeKeyStatements() {
        return Arrays.asList("DROP INDEX IF EXISTS SCM.\"COMPOSITEPRIMARYKEY..PRIMARY_KEY\"", "ALTER TABLE SCM.CompositePrimaryKey ALTER COLUMN secondPrimaryKey TYPE VARCHAR(5)", "ALTER TABLE SCM.CompositePrimaryKey ALTER COLUMN secondPrimaryKey NULL", "ALTER TABLE SCM.CompositePrimaryKey ALTER COLUMN secondPrimaryKey DROP DEFAULT", "ALTER TABLE SCM.CompositePrimaryKey ADD PRIMARY KEY (id)");
    }

    protected List<String> expectedAlterPrimaryKeyColumnStatements() {
        return Arrays.asList("DROP INDEX IF EXISTS SCM.\"TEST..PRIMARY_KEY\"", "ALTER TABLE SCM.Test RENAME COLUMN id TO renamedId", "ALTER TABLE SCM.Test ADD PRIMARY KEY (renamedId)");
    }

    protected List<String> expectedAlterColumnRenamingAndChangingNullability() {
        return Arrays.asList("ALTER TABLE SCM.Other RENAME COLUMN floatField TO blahField", "ALTER TABLE SCM.Other ALTER COLUMN blahField TYPE DECIMAL(20,3)", "ALTER TABLE SCM.Other ALTER COLUMN blahField NULL", "ALTER TABLE SCM.Other ALTER COLUMN blahField DROP DEFAULT");
    }

    protected List<String> expectedAlterColumnChangingLengthAndCase() {
        return Arrays.asList("ALTER TABLE SCM.Other RENAME COLUMN floatField TO FloatField", "ALTER TABLE SCM.Other ALTER COLUMN FloatField TYPE DECIMAL(20,3)");
    }

    protected String varCharCast(String value) {
        return value;
    }

    protected List<String> expectedAlterTableAddStringColumnWithDefaultStatement() {
        return Arrays.asList("ALTER TABLE SCM.Test ADD COLUMN stringField_with_default VARCHAR(6) DEFAULT 'N' NOT NULL");
    }

    protected List<String> expectedAutonumberUpdate() {
        return Arrays.asList("INSERT INTO SCM.Autonumber (id, value) VALUES('TestTable', (SELECT COALESCE(MAX(id) + 1, 1)  AS CurrentValue FROM SCM.TestTable)) ON DUPLICATE KEY UPDATE nextValue = GREATEST(nextValue, VALUES(nextValue))");
    }

    protected String expectedUpdateWithSelectMinimum() {
        String value1 = this.varCharCast("'S'");
        String value2 = this.varCharCast("'Y'");
        return "UPDATE " + this.tableName("Other") + " O SET intField = (SELECT MIN(intField) FROM " + this.tableName("Test") + " T WHERE ((T.charField = " + this.stringLiteralPrefix() + value1 + ") AND (T.stringField = O.stringField) AND (T.intField = O.intField))) WHERE (stringField = " + this.stringLiteralPrefix() + value2 + ")";
    }

    protected String expectedUpdateUsingAliasedDestinationTable() {
        return "UPDATE " + this.tableName("FloatingRateRate") + " A SET settlementFrequency = (SELECT settlementFrequency FROM " + this.tableName("FloatingRateDetail") + " B WHERE (A.floatingRateDetailId = B.id))";
    }

    protected String expectedYYYYMMDDToDate() {
        return "DATE_FROM_STR('20100101', 'yyyyMMdd')";
    }

    protected String expectedDateToYyyymmdd() {
        return "CAST(DATE_TO_STR(testField, 'yyyyMMdd') AS DECIMAL(8))";
    }

    protected String expectedDateToYyyymmddHHmmss() {
        return "CAST(DATE_TO_STR(testField, 'yyyyMMddHHmmss') AS DECIMAL(14))";
    }

    protected String expectedNow() {
        return "CURRENT_TIMESTAMP()";
    }

    protected List<String> expectedDropViewStatements() {
        return Arrays.asList("DROP VIEW " + this.tableName("TestView") + " IF EXISTS CASCADE");
    }

    protected String expectedSubstring() {
        return "SELECT SUBSTRING(field1, 1, 3) FROM " + this.tableName("schedule");
    }

    protected String expectedDaysBetween() {
        return "SELECT DATEDIFF(DAY,DATE_TO_STR(dateOne, 'yyyy-MM-dd'), DATE_TO_STR(dateTwo, 'yyyy-MM-dd')) FROM SCM.MyTable";
    }

    protected List<String> expectedAutonumberUpdateForNonIdColumn() {
        return Arrays.asList("INSERT INTO SCM.Autonumber (id, value) VALUES('TestTable', (SELECT COALESCE(MAX(generatedColumn) + 1, 1)  AS CurrentValue FROM SCM.TestTable)) ON DUPLICATE KEY UPDATE nextValue = GREATEST(nextValue, VALUES(nextValue))");
    }

    protected String expectedLeftPad() {
        return "SELECT CASE WHEN 10 - LENGTH(CAST(stringField AS STRING)) > 0 THEN SUBSTRING(REPLACE('                    ', ' ', 'j'), 1, 10 - LENGTH(CAST(stringField AS STRING))) || stringField ELSE SUBSTRING(stringField, 1, 10) END FROM SCM.Test";
    }

    protected String expectedStringFunctionCast() {
        return "CAST(MIN(field) AS VARCHAR(8))";
    }

    protected String expectedMergeSimple() {
        return "INSERT INTO SCM.foo(id, bar) SELECT somewhere.newId AS id, somewhere.newBar AS bar FROM SCM.somewhere ON DUPLICATE KEY UPDATE bar = values(bar)";
    }

    protected String expectedMergeComplex() {
        return "INSERT INTO SCM.foo(id, bar) SELECT somewhere.newId AS id, join.joinBar AS bar FROM SCM.somewhere INNER JOIN SCM.join ON (somewhere.newId = join.joinId) ON DUPLICATE KEY UPDATE bar = values(bar)";
    }

    protected String expectedMergeTargetInDifferentSchema() {
        return "INSERT INTO MYSCHEMA.foo(id, bar) SELECT somewhere.newId AS id, somewhere.newBar AS bar FROM SCM.somewhere ON DUPLICATE KEY UPDATE bar = values(bar)";
    }

    protected String expectedMergeSourceInDifferentSchema() {
        return "INSERT INTO SCM.foo(id, bar) SELECT somewhere.newId AS id, somewhere.newBar AS bar FROM MYSCHEMA.somewhere ON DUPLICATE KEY UPDATE bar = values(bar)";
    }

    protected String expectedMergeForAllPrimaryKeys() {
        return "INSERT INTO SCM.foo(id) SELECT somewhere.newId AS id FROM SCM.somewhere ON DUPLICATE KEY SKIP";
    }

    protected String expectedMergeWithUpdateExpressions() {
        return "INSERT INTO SCM.foo(id, bar) SELECT somewhere.newId AS id, somewhere.newBar AS bar FROM SCM.somewhere ON DUPLICATE KEY UPDATE bar = values(bar) + foo.bar";
    }

    protected String expectedAddDays() {
        return "DATE_ADD(testField, INTERVAL -20 DAY)";
    }

    protected String expectedAddMonths() {
        return "DATE_ADD(testField, INTERVAL -3 MONTH)";
    }

    protected List<String> expectedAlterRemoveColumnFromSimpleKeyStatements() {
        return Arrays.asList("DROP INDEX IF EXISTS SCM.\"TEST..PRIMARY_KEY\"", "ALTER TABLE SCM.Test DROP COLUMN id", "DROP SEQUENCE IF EXISTS SCM.Test_IDS_0");
    }

    protected List<String> expectedRenameTableStatements() {
        return ImmutableList.of((Object)"DROP INDEX IF EXISTS SCM.\"TEST..PRIMARY_KEY\"", (Object)"ALTER TABLE SCM.Test RENAME TO SCM.Renamed", (Object)"ALTER TABLE SCM.Renamed ADD PRIMARY KEY (id)");
    }

    protected List<String> getRenamingTableWithLongNameStatements() {
        return ImmutableList.of((Object)"DROP INDEX IF EXISTS SCM.\"123456789012345678901234567890XXX..PRIMARY_KEY\"", (Object)"ALTER TABLE SCM.123456789012345678901234567890XXX RENAME TO SCM.Blah", (Object)"ALTER TABLE SCM.Blah ADD PRIMARY KEY (id)");
    }

    protected List<String> expectedRenameIndexStatements() {
        return ImmutableList.of((Object)"DROP INDEX SCM.Test_1", (Object)"CREATE UNIQUE INDEX Test_2 ON SCM.Test (intField,floatField)");
    }

    protected List<String> expectedRenameTempIndexStatements() {
        return ImmutableList.of((Object)"DROP INDEX TempTest_1", (Object)"CREATE INDEX TempTest_2 ON TEMP_TempTest (intField,floatField)");
    }

    protected String expectedRandomString() {
        return "SUBSTRING(CAST(RAND() AS STRING), 3, 10)";
    }

    protected String expectedSelectOrderByNullsLast() {
        return "SELECT stringField FROM " + this.tableName("Alternate") + " ORDER BY stringField IS NULL, stringField";
    }

    protected String expectedSelectOrderByNullsFirstDesc() {
        return "SELECT stringField FROM " + this.tableName("Alternate") + " ORDER BY stringField IS NOT NULL, stringField DESC";
    }

    protected String expectedSelectOrderByTwoFields() {
        return "SELECT stringField1, stringField2 FROM " + this.tableName("Alternate") + " ORDER BY stringField1 IS NOT NULL, stringField1 DESC, stringField2 IS NULL, stringField2";
    }

    protected String expectedSelectFirstOrderByNullsLastDesc() {
        return "SELECT stringField FROM " + this.tableName("Alternate") + " ORDER BY stringField IS NULL, stringField DESC LIMIT 0,1";
    }

    protected String expectedSelectLiteralWithWhereClauseString() {
        return "SELECT 'LITERAL' FROM dual  WHERE ('ONE' = 'ONE')";
    }

    protected List<String> expectedAddTableFromStatements() {
        return ImmutableList.of((Object)"CREATE TABLE SCM.SomeTable (someField VARCHAR(3) NOT NULL, otherField DECIMAL(3,0) NOT NULL, PRIMARY KEY (someField))", (Object)"DROP INDEX IF EXISTS SCM.SomeTable_1", (Object)"CREATE INDEX SomeTable_1 ON SCM.SomeTable (otherField)", (Object)"INSERT INTO SCM.SomeTable SELECT someField, otherField FROM SCM.OtherTable");
    }

    protected String expectedHints1(int rowCount) {
        return "SELECT /*+ ORDERED, USE_INDEX(SCHEMA2.Foo, Foo_1), USE_INDEX(aliased, Foo_2) */ * FROM SCHEMA2.Foo INNER JOIN SCM.Bar ON (a = b) LEFT OUTER JOIN SCM.Fo ON (a = b) INNER JOIN SCM.Fum Fumble ON (a = b) ORDER BY a";
    }

    protected String expectedHints2(int rowCount) {
        return "SELECT /*+ USE_INDEX(SCM.Foo, Foo_1), ORDERED */ a, b FROM " + this.tableName("Foo") + " ORDER BY a FOR UPDATE";
    }

    protected String likeEscapeSuffix() {
        return "";
    }

    protected Collection<String> expectedAnalyseTableSql() {
        return SqlDialect.NO_STATEMENTS;
    }

    protected String expectedDeleteWithLimitAndWhere(String value) {
        return "DELETE FROM " + this.tableName("Test") + " WHERE (Test.stringField = " + this.stringLiteralPrefix() + value + ") LIMIT 1000";
    }

    protected String expectedDeleteWithLimitAndComplexWhere(String value1, String value2) {
        return "DELETE FROM " + this.tableName("Test") + " WHERE ((Test.stringField = " + this.stringLiteralPrefix() + value1 + ") OR (Test.stringField = " + this.stringLiteralPrefix() + value2 + ")) LIMIT 1000";
    }

    protected String expectedDeleteWithLimitWithoutWhere() {
        return "DELETE FROM " + this.tableName("Test") + " LIMIT 1000";
    }

    protected String expectedSelectWithExcept() {
        return null;
    }

    protected String expectedSelectWithDbLink() {
        return null;
    }

    protected String expectedSelectWithExceptAndDbLinkFormer() {
        return null;
    }

    protected String expectedSelectWithExceptAndDbLinkLatter() {
        return null;
    }
}

