/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.excel;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jxl.Cell;
import jxl.biff.FontRecord;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.UnderlineStyle;
import jxl.format.VerticalAlignment;
import jxl.write.Blank;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableHyperlink;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.alfasoftware.morf.dataset.Record;
import org.alfasoftware.morf.excel.AdditionalSchemaData;
import org.alfasoftware.morf.metadata.Column;
import org.alfasoftware.morf.metadata.DataType;
import org.alfasoftware.morf.metadata.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TableOutputter {
    private static final Log log = LogFactory.getLog(TableOutputter.class);
    private static final int NUMBER_OF_ROWS_IN_TITLE = 2;
    private static final int MAX_EXCEL_ROWS = 65536;
    private static final int MAX_EXCEL_COLUMNS = 256;
    private static final Set<DataType> supportedDataTypes = Sets.immutableEnumSet((Enum)DataType.STRING, (Enum[])new DataType[]{DataType.DECIMAL, DataType.BIG_INTEGER, DataType.INTEGER});
    private final AdditionalSchemaData additionalSchemaData;

    public TableOutputter(AdditionalSchemaData additionalSchemaData) {
        this.additionalSchemaData = additionalSchemaData;
    }

    public void table(int maxSampleRows, WritableWorkbook workbook, Table table, Iterable<Record> records) {
        boolean columnsTruncated;
        WritableSheet workSheet = workbook.createSheet(this.spreadsheetifyName(table.getName()), workbook.getNumberOfSheets());
        boolean bl = columnsTruncated = table.columns().size() > 256;
        if (columnsTruncated) {
            log.warn((Object)("Output for table '" + table.getName() + "' exceeds the maximum number of columns (" + 256 + ") in an Excel worksheet. It will be truncated."));
        }
        boolean rowsTruncated = false;
        try {
            int currentRow = 3;
            try {
                HashMap<String, Integer> helpTextRowNumbers = new HashMap<String, Integer>();
                currentRow = this.outputHelp(workSheet, table, currentRow, helpTextRowNumbers);
                Label exampleLabel = new Label(0, currentRow, "Example Data");
                exampleLabel.setCellFormat((CellFormat)this.getBoldFormat());
                workSheet.addCell((WritableCell)exampleLabel);
                ++currentRow;
                currentRow = this.outputDataHeadings(workSheet, table, currentRow, helpTextRowNumbers);
                currentRow = this.outputExampleData(maxSampleRows, workSheet, table, currentRow, records);
                Label dataLabel = new Label(0, currentRow, "Parameters to Set Up");
                dataLabel.setCellFormat((CellFormat)this.getBoldFormat());
                workSheet.addCell((WritableCell)dataLabel);
                ++currentRow;
                currentRow = this.outputDataHeadings(workSheet, table, currentRow, helpTextRowNumbers);
                currentRow = this.outputExampleData(null, workSheet, table, currentRow, records);
            }
            catch (RowLimitExceededException e) {
                log.warn((Object)e.getMessage());
                rowsTruncated = true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error outputting table '" + table.getName() + "'", e);
        }
        if (columnsTruncated || rowsTruncated) {
            StringBuilder truncatedSuffix = new StringBuilder();
            truncatedSuffix.append(" [");
            if (columnsTruncated) {
                truncatedSuffix.append("COLUMNS");
            }
            if (columnsTruncated && rowsTruncated) {
                truncatedSuffix.append(" & ");
            }
            if (rowsTruncated) {
                truncatedSuffix.append("ROWS");
            }
            truncatedSuffix.append(" TRUNCATED]");
            this.createTitle(workSheet, workSheet.getName() + truncatedSuffix.toString(), table.getName());
        } else {
            this.createTitle(workSheet, workSheet.getName(), table.getName());
        }
    }

    private String spreadsheetifyName(String name) {
        return StringUtils.capitalize((String)name).replaceAll("([A-Z][a-z])", " $1").trim();
    }

    private void createTitle(WritableSheet sheet, String title, String fileName) {
        try {
            Label cell = new Label(0, 0, title);
            WritableFont headingFont = new WritableFont(WritableFont.ARIAL, 16, WritableFont.BOLD);
            WritableCellFormat headingFormat = new WritableCellFormat(headingFont);
            cell.setCellFormat((CellFormat)headingFormat);
            sheet.addCell((WritableCell)cell);
            cell = new Label(1, 1, fileName);
            WritableFont fileNameFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.WHITE);
            WritableCellFormat fileNameFormat = new WritableCellFormat(fileNameFont);
            cell.setCellFormat((CellFormat)fileNameFormat);
            sheet.addCell((WritableCell)cell);
            cell = new Label(12, 0, "Copyright " + new SimpleDateFormat("yyyy").format(new Date()) + " Alfa Financial Software Ltd.");
            WritableCellFormat copyrightFormat = new WritableCellFormat();
            copyrightFormat.setAlignment(Alignment.RIGHT);
            cell.setCellFormat((CellFormat)copyrightFormat);
            sheet.addCell((WritableCell)cell);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private WritableFont getStandardFont() {
        return new WritableFont(WritableFont.ARIAL, 8);
    }

    private WritableCellFormat getStandardFormat() throws WriteException {
        WritableCellFormat standardFormat = new WritableCellFormat(this.getStandardFont());
        standardFormat.setVerticalAlignment(VerticalAlignment.TOP);
        return standardFormat;
    }

    private WritableCellFormat getBoldFormat() throws WriteException {
        WritableFont boldFont = new WritableFont(WritableFont.ARIAL, 8, WritableFont.BOLD);
        WritableCellFormat boldHeading = new WritableCellFormat(boldFont);
        boldHeading.setBorder(Border.BOTTOM, BorderLineStyle.MEDIUM);
        boldHeading.setVerticalAlignment(VerticalAlignment.CENTRE);
        boldHeading.setBackground(Colour.GRAY_25);
        WritableCellFormat boldFormat = new WritableCellFormat(boldFont);
        boldFormat.setVerticalAlignment(VerticalAlignment.TOP);
        return boldFormat;
    }

    private int outputExampleData(Integer numberOfExamples, WritableSheet workSheet, Table table, int startRow, Iterable<Record> records) throws WriteException {
        int currentRow = startRow;
        int rowsOutput = 0;
        for (Record record : records) {
            if (currentRow >= 65536 || numberOfExamples != null && rowsOutput >= numberOfExamples) continue;
            this.record(currentRow, workSheet, table, record);
            ++rowsOutput;
            ++currentRow;
        }
        if (currentRow >= 65536) {
            throw new RowLimitExceededException("Output for table '" + table.getName() + "' exceeds the maximum number of rows (" + 65536 + ") in an Excel worksheet. It will be truncated.");
        }
        return ++currentRow;
    }

    private int outputHelp(WritableSheet workSheet, Table table, int startRow, Map<String, Integer> helpTextRowNumbers) throws WriteException {
        int currentRow = startRow;
        Label dataLabel = new Label(0, currentRow, "Column Descriptions");
        dataLabel.setCellFormat((CellFormat)this.getBoldFormat());
        workSheet.addCell((WritableCell)dataLabel);
        ++currentRow;
        int currentColumn = 0;
        for (Column column : table.columns()) {
            if (column.getName().equals("id") || column.getName().equals("version")) continue;
            Label fieldName = new Label(0, currentRow, this.spreadsheetifyName(column.getName()));
            fieldName.setCellFormat((CellFormat)this.getBoldFormat());
            workSheet.addCell((WritableCell)fieldName);
            String typeString = column.getType() + "(" + column.getWidth() + (column.getScale() == 0 ? "" : "," + column.getScale()) + ")";
            Label fieldType = new Label(1, currentRow, typeString);
            fieldType.setCellFormat((CellFormat)this.getStandardFormat());
            workSheet.addCell((WritableCell)fieldType);
            String defaultValue = this.additionalSchemaData.columnDefaultValue(table, column.getName());
            Label fieldDefault = new Label(2, currentRow, defaultValue);
            fieldDefault.setCellFormat((CellFormat)this.getStandardFormat());
            workSheet.addCell((WritableCell)fieldDefault);
            workSheet.mergeCells(3, currentRow, 12, currentRow);
            String documentation = this.additionalSchemaData.columnDocumentation(table, column.getName());
            Label documentationLabel = new Label(3, currentRow, documentation);
            WritableCellFormat format = new WritableCellFormat((CellFormat)this.getStandardFormat());
            format.setWrap(true);
            format.setVerticalAlignment(VerticalAlignment.TOP);
            documentationLabel.setCellFormat((CellFormat)format);
            workSheet.addCell((WritableCell)documentationLabel);
            if (currentColumn >= 256) {
                Label truncatedWarning = new Label(13, currentRow, "[TRUNCATED]");
                truncatedWarning.setCellFormat((CellFormat)this.getBoldFormat());
                workSheet.addCell((WritableCell)truncatedWarning);
            }
            workSheet.setRowView(currentRow, 2250);
            helpTextRowNumbers.put(column.getName(), currentRow);
            ++currentRow;
            ++currentColumn;
        }
        workSheet.setRowGroup(startRow + 1, currentRow - 1, true);
        return ++currentRow;
    }

    private int outputDataHeadings(WritableSheet workSheet, Table table, int startRow, Map<String, Integer> helpTextRowNumbers) throws WriteException {
        int currentRow = startRow;
        int columnNumber = 0;
        WritableCellFormat columnHeadingFormat = this.getBoldFormat();
        columnHeadingFormat.setBackground(Colour.VERY_LIGHT_YELLOW);
        WritableFont font = new WritableFont(WritableFont.ARIAL, 8, WritableFont.BOLD);
        font.setColour(Colour.BLUE);
        font.setUnderlineStyle(UnderlineStyle.SINGLE);
        columnHeadingFormat.setFont((FontRecord)font);
        for (Column column : table.columns()) {
            if (columnNumber >= 256 || column.getName().equals("id") || column.getName().equals("version")) continue;
            WritableHyperlink linkToHelp = new WritableHyperlink(columnNumber, currentRow, this.spreadsheetifyName(column.getName()), workSheet, 0, helpTextRowNumbers.get(column.getName()).intValue());
            workSheet.addHyperlink(linkToHelp);
            WritableCell label = workSheet.getWritableCell(columnNumber, currentRow);
            label.setCellFormat((CellFormat)columnHeadingFormat);
            Cell helpCell = workSheet.getCell(0, helpTextRowNumbers.get(column.getName()).intValue());
            WritableHyperlink linkFromHelp = new WritableHyperlink(0, helpTextRowNumbers.get(column.getName()).intValue(), helpCell.getContents(), workSheet, columnNumber, currentRow);
            workSheet.addHyperlink(linkFromHelp);
            ++columnNumber;
        }
        return ++currentRow;
    }

    private void record(int row, WritableSheet worksheet, Table table, Record record) {
        int columnNumber = 0;
        WritableFont standardFont = new WritableFont(WritableFont.ARIAL, 8);
        WritableCellFormat standardFormat = new WritableCellFormat(standardFont);
        WritableCellFormat exampleFormat = new WritableCellFormat(standardFont);
        try {
            exampleFormat.setBackground(Colour.ICE_BLUE);
        }
        catch (WriteException e) {
            throw new RuntimeException("Failed to set example background colour", e);
        }
        for (Column column : table.columns()) {
            if (columnNumber >= 256 || column.getName().equals("id") || column.getName().equals("version")) continue;
            this.createCell(worksheet, column, columnNumber, row, record, standardFormat);
            ++columnNumber;
        }
    }

    private void createCell(WritableSheet currentWorkSheet, Column column, int columnNumber, int rowIndex, Record record, WritableCellFormat format) {
        Label writableCell = null;
        switch (column.getType()) {
            case STRING: {
                writableCell = new Label(columnNumber, rowIndex, record.getString(column.getName()));
                break;
            }
            case DECIMAL: {
                BigDecimal decimalValue = record.getBigDecimal(column.getName());
                try {
                    if (decimalValue == null) {
                        writableCell = new Blank(columnNumber, rowIndex);
                        break;
                    }
                    writableCell = new Number(columnNumber, rowIndex, decimalValue.doubleValue());
                    break;
                }
                catch (Exception e) {
                    throw new UnsupportedOperationException("Cannot generate Excel cell (parseDouble) for data [" + decimalValue + "] in column [" + column.getName() + "] of table [" + currentWorkSheet.getName() + "]", e);
                }
            }
            case BIG_INTEGER: 
            case INTEGER: {
                Long longValue = record.getLong(column.getName());
                try {
                    if (longValue == null) {
                        writableCell = new Blank(columnNumber, rowIndex);
                        break;
                    }
                    writableCell = new Number(columnNumber, rowIndex, (double)longValue.longValue());
                    break;
                }
                catch (Exception e) {
                    throw new UnsupportedOperationException("Cannot generate Excel cell (parseInt) for data [" + longValue + "] in column [" + column.getName() + "] of table [" + currentWorkSheet.getName() + "]", e);
                }
            }
            default: {
                throw new UnsupportedOperationException("Cannot output data type [" + column.getType() + "] to a spreadsheet");
            }
        }
        writableCell.setCellFormat((CellFormat)format);
        try {
            currentWorkSheet.addCell((WritableCell)writableCell);
        }
        catch (Exception e) {
            throw new RuntimeException("Error writing value to spreadsheet", e);
        }
    }

    boolean tableHasUnsupportedColumns(Table table) {
        return Iterables.any((Iterable)table.columns(), (Predicate)new Predicate<Column>(){

            public boolean apply(Column column) {
                return !supportedDataTypes.contains(column.getType());
            }
        });
    }

    private class RowLimitExceededException
    extends RuntimeException {
        public RowLimitExceededException(String message) {
            super(message);
        }
    }
}

