/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.excel;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jxl.Cell;
import jxl.Hyperlink;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.HyperlinkRecord;
import org.alfasoftware.morf.dataset.DataSetProducer;
import org.alfasoftware.morf.dataset.Record;
import org.alfasoftware.morf.metadata.DataSetUtils;
import org.alfasoftware.morf.metadata.Schema;
import org.alfasoftware.morf.metadata.Table;
import org.alfasoftware.morf.metadata.View;
import org.apache.commons.lang3.StringUtils;

public class SpreadsheetDataSetProducer
implements DataSetProducer {
    private static final Pattern sheetName = Pattern.compile("'([^']*)'.*");
    private final Map<String, List<Record>> tables = new HashMap<String, List<Record>>();
    private final List<Record> translations = new LinkedList<Record>();

    public SpreadsheetDataSetProducer(InputStream ... excelFiles) {
        for (InputStream stream : excelFiles) {
            this.parseWorkbook(stream);
        }
    }

    private Record createTranslationRecord(int id, String translation) {
        DataSetUtils.RecordBuilder record = DataSetUtils.record();
        record.setString("translationText", translation);
        Date now = new Date();
        record.setString("changeDate", new SimpleDateFormat("yyyyMMdd").format(now));
        record.setString("changedTime", new SimpleDateFormat("hhmmss").format(now));
        record.setInteger("localeSequenceNumber", Integer.valueOf(1));
        record.setInteger("translationSequenceNumber", Integer.valueOf(id));
        record.setInteger("translationId", Integer.valueOf(id));
        record.setInteger("id", Integer.valueOf(id));
        return record;
    }

    private HyperlinkRecord getHyperlink(Sheet sheet, int column, int row) {
        for (Hyperlink link : sheet.getHyperlinks()) {
            if (link.getColumn() != column || link.getRow() != row) continue;
            return (HyperlinkRecord)link;
        }
        return null;
    }

    private void parseWorkbook(InputStream inputStream) {
        try (Workbook workbook = null;){
            WorkbookSettings settings = new WorkbookSettings();
            settings.setEncoding("CP1252");
            workbook = Workbook.getWorkbook((InputStream)inputStream, (WorkbookSettings)settings);
            Sheet sheet = workbook.getSheet(0);
            boolean column = true;
            for (int row = 2; row < sheet.getRows(); ++row) {
                Cell cell = sheet.getCell(1, row);
                if (StringUtils.isEmpty((CharSequence)cell.getContents())) {
                    break;
                }
                HyperlinkRecord hyperlink = this.getHyperlink(sheet, cell.getColumn() - 1, cell.getRow());
                String worksheetName = this.getDestinationWorksheet(hyperlink);
                if (workbook.getSheet(worksheetName) == null) {
                    throw new IllegalStateException("Failed to find worksheet with name [" + worksheetName + "]");
                }
                List<Record> records = this.getRecords(workbook.getSheet(worksheetName));
                this.tables.put(cell.getContents(), records);
            }
        }
    }

    private String getDestinationWorksheet(HyperlinkRecord hyperlink) {
        Matcher matcher = sheetName.matcher(hyperlink.getLocation());
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return hyperlink.getLocation();
    }

    private int findHeaderRow(Sheet sheet) {
        int row;
        for (row = 0; row < sheet.getRows(); ++row) {
            if (!"Parameters to Set Up".equalsIgnoreCase(sheet.getCell(0, row).getContents())) continue;
            ++row;
            break;
        }
        while (row < sheet.getRows()) {
            HyperlinkRecord hyperlink = this.getHyperlink(sheet, 0, row);
            if (hyperlink != null) {
                return row;
            }
            ++row;
        }
        throw new IllegalStateException("Could not find header row in worksheet [" + sheet.getName() + "]");
    }

    private int getTranslationsColumnIndex(Sheet sheet, int headingRow) {
        int i;
        boolean hasBlank = false;
        for (i = 0; i < sheet.getRow(headingRow).length; ++i) {
            if (sheet.getCell(i, headingRow).getContents().length() != 0) continue;
            hasBlank = true;
            break;
        }
        if (!hasBlank) {
            return -1;
        }
        while (i < sheet.getRow(headingRow).length) {
            if (sheet.getCell(i, headingRow).getContents().length() > 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int countHeadings(Sheet sheet, int headingRowIndex) {
        for (int i = 0; i < sheet.getRow(headingRowIndex).length; ++i) {
            if (sheet.getCell(i, headingRowIndex).getContents().length() != 0) continue;
            return i;
        }
        return sheet.getRow(headingRowIndex).length;
    }

    private List<Record> getRecords(Sheet sheet) {
        try {
            Cell[] cells;
            long id = 1L;
            int row = this.findHeaderRow(sheet);
            HashMap<String, Integer> columnHeadingsMap = new HashMap<String, Integer>();
            for (int i = 0; i < this.countHeadings(sheet, row); ++i) {
                columnHeadingsMap.put(this.columnName(sheet.getCell(i, row).getContents()), i);
            }
            int translationColumn = this.getTranslationsColumnIndex(sheet, row);
            ++row;
            LinkedList<Record> records = new LinkedList<Record>();
            while (row < sheet.getRows() && !this.allBlank(cells = sheet.getRow(row))) {
                records.add(this.createRecord(id++, columnHeadingsMap, translationColumn, cells));
                ++row;
            }
            return records;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse worksheet [" + sheet.getName() + "]", e);
        }
    }

    private boolean allBlank(Cell ... cells) {
        for (Cell cell : cells) {
            if (cell.getContents().length() == 0) continue;
            return false;
        }
        return true;
    }

    private Record createRecord(long id, Map<String, Integer> columnHeadingsMap, int translationColumn, Cell ... cells) {
        int translationId;
        if (translationColumn != -1 && cells[translationColumn].getContents().length() > 0) {
            translationId = this.translations.size() + 1;
            this.translations.add(this.createTranslationRecord(translationId, cells[translationColumn].getContents()));
        } else {
            translationId = 0;
        }
        DataSetUtils.RecordBuilder record = DataSetUtils.record();
        for (Map.Entry<String, Integer> column : columnHeadingsMap.entrySet()) {
            if (column.getValue() < cells.length) {
                record.setString(column.getKey(), cells[column.getValue()].getContents());
                continue;
            }
            record.setString(column.getKey(), "");
        }
        record.setLong("id", Long.valueOf(id));
        record.setInteger("translationId", Integer.valueOf(translationId));
        return record;
    }

    private String columnName(String longName) {
        String noSpaces = longName.replaceAll(" ", "");
        return noSpaces.substring(0, 1).toLowerCase() + noSpaces.substring(1);
    }

    public Schema getSchema() {
        return new Schema(){

            public Table getTable(String name) {
                throw new UnsupportedOperationException("Cannot get the metadata of a table for a spreadsheet");
            }

            public boolean isEmptyDatabase() {
                return SpreadsheetDataSetProducer.this.tables.isEmpty();
            }

            public boolean tableExists(String name) {
                return SpreadsheetDataSetProducer.this.tables.containsKey(name);
            }

            public Collection<String> tableNames() {
                return SpreadsheetDataSetProducer.this.tables.keySet();
            }

            public Collection<Table> tables() {
                throw new UnsupportedOperationException("Cannot get the metadata of a table for a spreadsheet");
            }

            public boolean viewExists(String name) {
                return false;
            }

            public View getView(String name) {
                throw new IllegalArgumentException("Invalid view [" + name + "]. Views are not supported in spreadsheets");
            }

            public Collection<String> viewNames() {
                return Collections.emptySet();
            }

            public Collection<View> views() {
                return Collections.emptySet();
            }
        };
    }

    public void open() {
    }

    public void close() {
    }

    public Iterable<Record> records(String tableName) {
        return this.tables.get(tableName);
    }

    public boolean isTableEmpty(String tableName) {
        return this.tables.get(tableName).isEmpty();
    }
}

