/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.excel;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.UnderlineStyle;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableHyperlink;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.alfasoftware.morf.dataset.DataSetConsumer;
import org.alfasoftware.morf.dataset.Record;
import org.alfasoftware.morf.excel.AdditionalSchemaData;
import org.alfasoftware.morf.excel.DefaultAdditionalSchemaDataImpl;
import org.alfasoftware.morf.excel.TableOutputter;
import org.alfasoftware.morf.metadata.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpreadsheetDataSetConsumer
implements DataSetConsumer {
    private static final Log log = LogFactory.getLog(SpreadsheetDataSetConsumer.class);
    private static final int NUMBER_OF_ROWS_IN_TITLE = 2;
    private static final int DEFAULT_SAMPLE_ROWS = 5;
    private final OutputStream documentOutputStream;
    private WritableWorkbook workbook;
    private final Optional<Map<String, Integer>> rowsPerTable;
    private final TableOutputter tableOutputter;

    public SpreadsheetDataSetConsumer(OutputStream documentOutputStream) {
        this(documentOutputStream, Optional.empty());
    }

    public SpreadsheetDataSetConsumer(OutputStream documentOutputStream, Optional<Map<String, Integer>> rowsPerTable) {
        this(documentOutputStream, rowsPerTable, new DefaultAdditionalSchemaDataImpl());
    }

    public SpreadsheetDataSetConsumer(OutputStream documentOutputStream, Optional<Map<String, Integer>> rowsPerTable, AdditionalSchemaData additionalSchemaData) {
        this(documentOutputStream, rowsPerTable, new TableOutputter(additionalSchemaData));
    }

    SpreadsheetDataSetConsumer(OutputStream documentOutputStream, Optional<Map<String, Integer>> rowsPerTable, TableOutputter tableOutputter) {
        this.documentOutputStream = documentOutputStream;
        this.tableOutputter = tableOutputter;
        this.rowsPerTable = rowsPerTable;
    }

    public void open() {
        try {
            this.workbook = Workbook.createWorkbook((OutputStream)this.documentOutputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating writable workbook", e);
        }
    }

    public void createIndex() {
        WritableSheet sheet = this.workbook.createSheet(this.spreadsheetifyName("Index"), 0);
        this.createTitle(sheet, "Index");
        try {
            String[] names = this.workbook.getSheetNames();
            for (int currentSheet = 1; currentSheet < names.length; ++currentSheet) {
                WritableHyperlink link = new WritableHyperlink(0, currentSheet - 1 + 2, names[currentSheet], this.workbook.getSheet(currentSheet), 0, 0);
                sheet.addHyperlink(link);
                String fileName = this.workbook.getSheet(currentSheet).getCell(1, 1).getContents();
                Label fileNameLabel = new Label(1, currentSheet - 1 + 2, fileName);
                WritableFont fileNameFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK);
                WritableCellFormat fileNameFormat = new WritableCellFormat(fileNameFont);
                fileNameLabel.setCellFormat((CellFormat)fileNameFormat);
                sheet.addCell((WritableCell)fileNameLabel);
                link = new WritableHyperlink(0, 1, "Back to index", sheet, 0, currentSheet + 2 - 1);
                this.workbook.getSheet(currentSheet).addHyperlink(link);
                this.workbook.getSheet(currentSheet).setColumnView(0, 13);
            }
            sheet.setColumnView(0, 35);
            sheet.setColumnView(1, 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String spreadsheetifyName(String name) {
        return StringUtils.capitalize((String)name).replaceAll("([A-Z])", " $1").trim();
    }

    protected void createTitle(WritableSheet sheet, String title) {
        try {
            Label cell = new Label(0, 0, title);
            WritableFont headingFont = new WritableFont(WritableFont.ARIAL, 16, WritableFont.BOLD);
            WritableCellFormat headingFormat = new WritableCellFormat(headingFont);
            cell.setCellFormat((CellFormat)headingFormat);
            sheet.addCell((WritableCell)cell);
            cell = new Label(12, 0, "Copyright " + new SimpleDateFormat("yyyy").format(new Date()) + " Alfa Financial Software Ltd.");
            WritableCellFormat copyrightFormat = new WritableCellFormat();
            copyrightFormat.setAlignment(Alignment.RIGHT);
            cell.setCellFormat((CellFormat)copyrightFormat);
            sheet.addCell((WritableCell)cell);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close(DataSetConsumer.CloseState closeState) {
        try {
            this.createIndex();
            this.workbook.write();
            this.workbook.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Error closing writable workbook", e);
        }
    }

    public void table(Table table, Iterable<Record> records) {
        Integer maxSampleRows = 5;
        if (this.rowsPerTable.isPresent()) {
            maxSampleRows = this.rowsPerTable.get().get(table.getName().toUpperCase());
        }
        if (maxSampleRows == null) {
            log.info((Object)("File [" + table.getName() + "] excluded in configuration."));
        } else if (this.tableOutputter.tableHasUnsupportedColumns(table)) {
            log.info((Object)("File [" + table.getName() + "] skipped - unsupported columns."));
        } else {
            log.info((Object)("File [" + table.getName() + "] generating..."));
            this.tableOutputter.table(maxSampleRows, this.workbook, table, records);
        }
    }
}

