/*
 * Decompiled with CFR 0.152.
 */
package org.akhikhl.gretty;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class FilteringClassLoader
extends URLClassLoader {
    private final List<String> serverClasses = new ArrayList<String>();
    private final List<String> serverResources = new ArrayList<String>();

    public FilteringClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public void addServerClass(String serverClass) {
        this.serverClasses.add(serverClass);
        this.serverResources.add(serverClass.replace('.', '/'));
        this.serverResources.add("META-INF/services/" + serverClass);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (String serverClass : this.serverClasses) {
            if (!name.startsWith(serverClass)) continue;
            throw new ClassNotFoundException(name);
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        for (String serverResource : this.serverResources) {
            if (!name.startsWith(serverResource)) continue;
            return Collections.emptyEnumeration();
        }
        return super.getResources(name);
    }
}

