/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.semver.vcs;

import com.github.zafarkhaja.semver.Version;
import java.util.Objects;
import org.ajoberstar.semver.vcs.Scope;
import org.ajoberstar.semver.vcs.Stage;
import org.ajoberstar.semver.vcs.Versioner;

public final class Versioners {
    public static final Version VERSION_0 = Version.forIntegers((int)0, (int)0, (int)0);

    private Versioners() {
        throw new AssertionError((Object)"Cannot instantiate this class.");
    }

    public static Versioner identity() {
        return (base, vcs) -> base;
    }

    public static Versioner force(String version) {
        Version forced = Version.valueOf((String)version);
        return (base, vcs) -> forced;
    }

    public static Versioner rebuild() {
        return (base, vcs) -> vcs.getCurrentVersion().orElseThrow(() -> new IllegalStateException("Cannot rebuild since current revision doesn't have a version."));
    }

    public static Versioner enforcePrecedence() {
        return (base, vcs) -> {
            Version previous = vcs.getPreviousVersion().orElse(base);
            if (base.greaterThanOrEqualTo(previous)) {
                return base;
            }
            throw new IllegalArgumentException("Inferred version (" + base + ") must have higher precedence than previous (" + previous + ")");
        };
    }

    public static Versioner forScopeAndStage(Scope scope, Stage stage, boolean enforcePrecedence) {
        Objects.requireNonNull(scope, "Scope cannot be null.");
        Objects.requireNonNull(stage, "Stage cannot be null.");
        return Versioners.identity().compose(enforcePrecedence ? Versioners.enforcePrecedence() : Versioners.identity()).compose(stage.getVersioner()).compose(scope.getVersioner());
    }
}

